/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.spi.ResultFormatSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkDataWritable;
import jp.naist.se.stigmata.ui.swing.ClassNameObfuscator;
import jp.naist.se.stigmata.ui.swing.CompareTableCellRenderer;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairComparisonResultSetPane
extends JPanel
implements BirthmarkDataWritable {
    private static final long serialVersionUID = 3298346465652354302L;
    private StigmataFrame frame;
    private BirthmarkContext context;
    private DefaultTableModel model = new PairComparisonResultSetTableModel();
    private JTable table = new JTable(this.model);
    private JLabel averageLabel;
    private JLabel maximumLabel;
    private JLabel minimumLabel;
    private List<ComparisonPair> list = new ArrayList<ComparisonPair>();
    private double average;
    private double maximum;
    private double minimum;

    public PairComparisonResultSetPane(StigmataFrame frame, ComparisonResultSet resultset) {
        this.frame = frame;
        this.context = resultset.getContext();
        for (ComparisonPair pair : resultset) {
            this.list.add(pair);
        }
        this.initComponent();
        this.initData(this.model, this.list);
    }

    @Override
    public void writeData(PrintWriter out, ResultFormatSpi service) throws IOException {
        service.getComparisonResultFormat().printResult(out, new CertainPairComparisonResultSet(this.list.toArray(new ComparisonPair[this.list.size()]), this.context));
    }

    private void obfuscateClassNames() {
        ClassNameObfuscator obfuscator = new ClassNameObfuscator();
        ArrayList<ComparisonPair> newList = new ArrayList<ComparisonPair>();
        for (ComparisonPair pair : this.list) {
            BirthmarkSet set1 = obfuscator.obfuscateClassName(pair.getTarget1());
            BirthmarkSet set2 = obfuscator.obfuscateClassName(pair.getTarget2());
            newList.add(new ComparisonPair(set1, set2, this.context));
        }
        try {
            File file = this.frame.getSaveFile(Messages.getStringArray("obfuscationmapping.extension"), Messages.getString("obfuscationmapping.description"));
            obfuscator.outputNameMappings(file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("error.dialog.title"), 0);
            return;
        }
        PairComparisonResultSetTableModel newModel = new PairComparisonResultSetTableModel();
        this.initData(newModel, newList);
        this.list = newList;
        this.model = newModel;
        this.table.setModel(newModel);
    }

    private void initData(DefaultTableModel model, List<ComparisonPair> list) {
        this.maximum = 0.0;
        this.minimum = 1.0;
        this.average = 0.0;
        model.setColumnIdentifiers(Messages.getStringArray("comparepair.table.columns"));
        for (ComparisonPair pair : list) {
            double similarity = pair.calculateSimilarity();
            if (similarity > this.maximum) {
                this.maximum = similarity;
            }
            if (similarity < this.minimum) {
                this.minimum = similarity;
            }
            this.average += similarity;
            model.addRow(new Object[]{pair.getTarget1().getClassName(), pair.getTarget2().getClassName(), new Double(similarity)});
        }
        this.average /= (double)list.size();
    }

    private void initComponent() {
        Box buttonPanel = Box.createHorizontalBox();
        JPanel similarityPane = new JPanel(new GridLayout(1, 3));
        Box southPanel = Box.createVerticalBox();
        JButton saveButton = Utility.createButton("savecomparison");
        JButton obfuscateButton = Utility.createButton("obfuscate");
        JScrollPane scroll = new JScrollPane();
        this.averageLabel = new JLabel(Double.toString(this.average));
        this.maximumLabel = new JLabel(Double.toString(this.maximum));
        this.minimumLabel = new JLabel(Double.toString(this.minimum));
        scroll.setViewportView(this.table);
        this.table.setDefaultRenderer(Double.class, new CompareTableCellRenderer());
        similarityPane.setBorder(new TitledBorder(Messages.getString("similarity.border")));
        this.averageLabel.setBorder(new TitledBorder(Messages.getString("average.border")));
        this.maximumLabel.setBorder(new TitledBorder(Messages.getString("maximum.border")));
        this.minimumLabel.setBorder(new TitledBorder(Messages.getString("minimum.border")));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)southPanel, "South");
        similarityPane.add(this.averageLabel);
        similarityPane.add(this.maximumLabel);
        similarityPane.add(this.minimumLabel);
        southPanel.add(similarityPane);
        southPanel.add(buttonPanel);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(saveButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(obfuscateButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = PairComparisonResultSetPane.this.table.rowAtPoint(e.getPoint());
                    int col = PairComparisonResultSetPane.this.table.columnAtPoint(e.getPoint());
                    if (col >= 1 && col < PairComparisonResultSetPane.this.table.getColumnCount() && row >= 0 && row < PairComparisonResultSetPane.this.table.getRowCount()) {
                        ComparisonPair pair = (ComparisonPair)PairComparisonResultSetPane.this.list.get(row);
                        PairComparisonResultSetPane.this.frame.compareDetails(pair.getTarget1(), pair.getTarget2(), PairComparisonResultSetPane.this.context);
                    }
                }
            }
        });
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PairComparisonResultSetPane.this.frame.saveAction(PairComparisonResultSetPane.this);
            }
        });
        obfuscateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PairComparisonResultSetPane.this.obfuscateClassNames();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairComparisonResultSetTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 93457234571623497L;

        private PairComparisonResultSetTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 2) {
                return Double.class;
            }
            return String.class;
        }
    }
}

