/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelectionPane;
import jp.naist.se.stigmata.ui.swing.ClasspathSettingsPane;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.TargetSelectionPane;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.WellknownClassesSettingsPane;
import jp.naist.se.stigmata.utils.WellknownClassManager;

public class ControlPane
extends JPanel {
    private static final long serialVersionUID = 983547612346543645L;
    private StigmataFrame stigmata;
    private BirthmarkSelectionPane birthmarks;
    private TargetSelectionPane targetX;
    private TargetSelectionPane targetY;
    private ClasspathSettingsPane classpath;
    private WellknownClassesSettingsPane wellknownClassses;
    private JTabbedPane controlTab;
    private JButton compareButton;
    private JButton extractButton;
    private JButton resetButton;
    private JComboBox comparisonMethods;

    public ControlPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initComponents();
        Utility.addNewTab("targets", this.controlTab, this.createControlPane());
        Utility.addNewTab("wellknown", this.controlTab, this.createWellknownClassPane());
        this.classpath = new ClasspathSettingsPane(stigmata);
        Utility.addNewTab("classpath", this.controlTab, this.classpath);
        this.reset();
    }

    public void reset() {
        this.birthmarks.reset();
        this.targetX.removeAllElements();
        this.targetY.removeAllElements();
        this.classpath.reset();
        this.wellknownClassses.reset();
    }

    private JComponent createWellknownClassPane() {
        BirthmarkContext b = this.stigmata.getStigmata().createContext();
        this.wellknownClassses = new WellknownClassesSettingsPane(b.getWellknownClassManager());
        return this.wellknownClassses;
    }

    private JComponent createControlPane() {
        Box mainPane = new Box(0);
        JPanel center = new JPanel(new BorderLayout());
        BirthmarkSelectionPane birthmarks = new BirthmarkSelectionPane(this.stigmata);
        this.targetX = new TargetSelectionPane(this.stigmata);
        this.targetY = new TargetSelectionPane(this.stigmata);
        birthmarks.setBorder(new TitledBorder(Messages.getString("birthmarkspane.border")));
        this.birthmarks = birthmarks;
        this.targetX.addTargetExtensions(Messages.getStringArray("targets.extensions"));
        this.targetX.setDescription(Messages.getString("targets.description"));
        this.targetX.setBorder(new TitledBorder(Messages.getString("targetx.border")));
        this.targetY.addTargetExtensions(Messages.getStringArray("targets.extensions"));
        this.targetY.setDescription(Messages.getString("targets.description"));
        this.targetY.setBorder(new TitledBorder(Messages.getString("targety.border")));
        center.add((Component)mainPane, "Center");
        center.add((Component)birthmarks, "South");
        mainPane.add(Box.createHorizontalGlue());
        mainPane.add(this.targetX);
        mainPane.add(Box.createHorizontalGlue());
        mainPane.add(this.targetY);
        mainPane.add(Box.createHorizontalGlue());
        DataChangeListener dcl = new DataChangeListener(){

            public void valueChanged(Object source) {
                ControlPane.this.checkButtonEnabled();
            }
        };
        this.targetX.addDataChangeListener(dcl);
        this.targetY.addDataChangeListener(dcl);
        birthmarks.addDataChangeListener(dcl);
        return center;
    }

    private void checkButtonEnabled() {
        String[] valueX = this.targetX.getValues();
        String[] valueY = this.targetY.getValues();
        String[] targets = this.birthmarks.getSelectedServices();
        this.extractButton.setEnabled((valueX != null && valueX.length > 0 || valueY != null && valueY.length > 0) && targets != null && targets.length > 0);
        this.compareButton.setEnabled(valueX != null && valueX.length > 0 && valueY != null && valueY.length > 0 && targets != null && targets.length > 0);
    }

    private void extractButtonActionPerformed(ActionEvent e) {
        BirthmarkContext context = this.initAction();
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        HashSet<String> targets = new HashSet<String>();
        if (fileX != null && fileX.length > 0) {
            for (String file : fileX) {
                targets.add(file);
            }
        }
        if (fileY != null && fileY.length > 0) {
            for (String file : fileY) {
                targets.add(file);
            }
        }
        this.stigmata.extract(this.birthmarks.getSelectedServices(), targets.toArray(new String[targets.size()]), context);
    }

    private void compareRoundRobin() {
        BirthmarkContext context = this.initAction();
        this.stigmata.compareRoundRobin(this.birthmarks.getSelectedServices(), this.targetX.getValues(), this.targetY.getValues(), context);
    }

    private void compareSpecifiedPair() {
        BirthmarkContext context = this.initAction();
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        this.stigmata.compareSpecifiedPair(this.birthmarks.getSelectedServices(), fileX, fileY, context);
    }

    private void compareGuessedPair() {
        BirthmarkContext context = this.initAction();
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        this.stigmata.compareGuessedPair(this.birthmarks.getSelectedServices(), fileX, fileY, context);
    }

    private BirthmarkContext initAction() {
        Stigmata s = this.stigmata.getStigmata();
        BirthmarkContext context = s.createContext();
        ClasspathContext bytecode = context.getBytecodeContext();
        WellknownClassManager manager = context.getWellknownClassManager();
        this.classpath.updateClasspathContext(bytecode);
        this.wellknownClassses.setWellknownClasses(manager);
        return context;
    }

    private void initComponents() {
        JPanel south = new JPanel();
        this.controlTab = new JTabbedPane();
        this.resetButton = Utility.createButton("reset");
        this.extractButton = Utility.createButton("extract");
        this.compareButton = Utility.createButton("compare");
        this.comparisonMethods = new JComboBox();
        String[] items = Messages.getStringArray("comparison.methods");
        for (int i = 0; i < items.length; ++i) {
            this.comparisonMethods.addItem(items[i]);
        }
        this.setLayout(new BorderLayout());
        south.add(this.resetButton);
        south.add(this.extractButton);
        south.add(this.compareButton);
        south.add(this.comparisonMethods);
        this.add((Component)south, "South");
        this.add((Component)this.controlTab, "Center");
        this.extractButton.setEnabled(false);
        this.compareButton.setEnabled(false);
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPane.this.reset();
            }
        });
        this.extractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPane.this.extractButtonActionPerformed(e);
            }
        });
        this.compareButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = (String)ControlPane.this.comparisonMethods.getSelectedItem();
                if (item.equals(Messages.getString("roundrobin.label"))) {
                    ControlPane.this.compareRoundRobin();
                } else if (item.equals(Messages.getString("guessedpair.label"))) {
                    ControlPane.this.compareGuessedPair();
                } else if (item.equals(Messages.getString("specifiedpair.label"))) {
                    ControlPane.this.compareSpecifiedPair();
                }
            }
        });
    }
}

