/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.Commands;
import net.murakamin.sticker.commands.enums.PostChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.PreChildCommandExecutionType;

public class VariablesCommand implements ParentCommand
{

	private final Commands childlen = new Commands();

	public void addChild(final ExecutableCommand child)
	{
		this.childlen.add(child);
	}

	public void execute(final CommandRunner runner) throws Exception
	{
		runner.run(this);
	}

	public Commands getChildlen()
	{
		return this.childlen;
	}

	public VersionTerm getVersionTerm()
	{
		return new VersionTerm("0.1.4");
	}

	public boolean isDebugPrint()
	{
		return true;
	}

	public PostChildCommandExecutionType postChildCommandExecute(
	        final CommandRunner runner) throws Exception
	{
		return PostChildCommandExecutionType.NOT_REPEAT;
	}

	public PreChildCommandExecutionType preChildCommandExecute(
	        final CommandRunner runner) throws Exception
	{
		return PreChildCommandExecutionType.CHILD_EXECUTE;
	}

	@Override
	public String toString()
	{
		return "<Variables> variables definition.";
	}
}
