/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.Commands;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.commands.enums.PostChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.PreChildCommandExecutionType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StickerCommand implements ParentCommand
{

	private final Commands childlen = new Commands();
	private boolean debug = false;
	private final Log log = LogFactory.getLog(Command.class);

	private String version;

	public StickerCommand()
	{
		super();
	}

	public void addChild(final ExecutableCommand child)
	{
		this.childlen.add(child);
	}

	public void execute(final CommandRunner runner) throws Exception
	{
		this.log.info("`t@Co[W : " + this.getVersion());

		if (Sticker.VERSION.compareTo(this.version) < 0)
		{
			throw new CommandExecutionException(this, "`t@C̃o[WႢ܂");
		}
		runner.run(this);
	}

	public Commands getChildlen()
	{
		return this.childlen;
	}

	public String getVersion()
	{
		return version;
	}

	public VersionTerm getVersionTerm()
	{
		return VersionTerm.PERMANENT_COMMAND;
	}

	public boolean isDebug()
	{
		return this.debug;
	}

	public boolean isDebugPrint()
	{
		return true;
	}

	public PostChildCommandExecutionType postChildCommandExecute(
	        final CommandRunner runner) throws Exception
	{
		if (runner != null)
		{
			runner.getConnectionPool().disConnectAllConnections();
		}

		return PostChildCommandExecutionType.NOT_REPEAT;
	}

	public PreChildCommandExecutionType preChildCommandExecute(
	        final CommandRunner runner) throws Exception
	{
		return PreChildCommandExecutionType.CHILD_EXECUTE;
	}

	public void setDebug(final boolean debug)
	{
		this.debug = debug;
	}

	public void setVersion(final String version)
	{
		this.version = version;
	}

	@Override
	public String toString()
	{
		StringBuffer buffer = new StringBuffer();
		buffer.append("Sticker version:");
		buffer.append(this.getVersion());

		return buffer.toString();
	}

}
