/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import net.murakamin.sticker.commands.util.StickerContextUtil;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class ShellCommand implements Command
{

	private boolean async;
	private String command;
	private boolean exitOnError;

	public void execute(final CommandRunner runner) throws Exception
	{

		String commandShell = StringUtils.EMPTY;
		if (SystemUtils.IS_OS_WINDOWS)
		{
			commandShell = "cmd /c ";
		}

		StickerContext context = runner.getStickerContext();
		String command = StickerContextUtil.applyContextVariable(context, this
		        .getCommand());
		String concreteCommand = StickerContextUtil.getReplacementString(
		        context, command);

		Runtime currentRuntime = Runtime.getRuntime();
		if (async == true)
		{
			// 񓯊
			currentRuntime.exec(commandShell + concreteCommand);
		} else
		{
			// 
			Process proc = currentRuntime.exec(commandShell + concreteCommand);
			proc.waitFor();
			if (this.isExitOnError())
			{
				if (proc.exitValue() != 0)
				{
					throw new CommandExecutionException(this,
					        "The error was detected by executing the command.\n  "
					                + this.getCommand());
				}
			}
		}
		runner.run(this);
	}

	public String getCommand()
	{
		return this.command;
	}

	public VersionTerm getVersionTerm()
	{
		return VersionTerm.PERMANENT_COMMAND;
	}

	public boolean isAsync()
	{
		return async;
	}

	public boolean isDebugPrint()
	{
		return true;
	}

	public boolean isExitOnError()
	{
		return exitOnError;
	}

	public void setAsync(final boolean asynchronous)
	{
		this.async = asynchronous;
	}

	public void setCommand(final String statement)
	{
		this.command = statement;
	}

	public void setExitOnError(final boolean exitOnError)
	{
		this.exitOnError = exitOnError;
	}

	@Override
	public String toString()
	{

		StringBuffer buffer = new StringBuffer();

		buffer.append("<shell> Shell command execute:\n");

		buffer.append(" asynchronous:");
		buffer.append(this.isAsync());
		buffer.append("\n");

		buffer.append(" exitOnError:");
		buffer.append(this.isExitOnError());
		buffer.append("\n");

		buffer.append(" command:");
		buffer.append(this.getCommand());
		buffer.append("\n");

		return buffer.toString();
	}

}
