package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;

/**
 * Interface that all Sticker commands should implements.
 * 
 * @author Y.Murakamin
 * 
 * @see net.murakamin.sticker.commands.ParentCommand
 * @see net.murakamin.sticker.commands.Command
 * @see net.murakamin.sticker.CommandRunner
 */
public interface ExecutableCommand
{

	/**
	 * The command is executed. It is called from
	 * {@link net.murakamin.sticker.CommandRunner}, and the command is
	 * executed.
	 * 
	 * @param runner
	 *            The CommandRunner Object
	 * 
	 * @throws Exception
	 */
	void execute(final CommandRunner runner) throws Exception;

	/**
	 * Version information to which the command is effective is returned.
	 * 
	 * @return Version information to which command is effective
	 * 
	 */
	VersionTerm getVersionTerm();

	/**
	 * True when debugging output is effective
	 * 
	 * @return True when debugging output is effective
	 * 
	 */
	boolean isDebugPrint();

}