/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/**
 * Context object shared between each command while executing Sticker
 * 
 * @author Y.Murakamin
 */
final class StickerContextImpl implements StickerContext
{

	private final Map<String, Object> map = new HashMap<String, Object>();

	private final Stack<Map<String, Object>> fieldValueStack = new Stack<Map<String, Object>>();

	/**
	 * the constractor
	 */
	protected StickerContextImpl()
	{
		super();
	}

	/**
	 * All content of this context is cleared.
	 */
	public void clear()
	{
		this.map.clear();
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#containsKey(java.lang.Object)
	 */
	public boolean containsKey(final Object key)
	{
		return this.map.containsKey(key);
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#containsValue(java.lang.Object)
	 */
	public boolean containsValue(final Object value)
	{
		return this.map.containsValue(value);
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#entrySet()
	 */
	@SuppressWarnings("unchecked")
	public Set entrySet()
	{
		return this.map.entrySet();
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#get(java.lang.Object)
	 */
	public Object get(final Object key)
	{
		return this.map.get(key);
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#isEmpty()
	 */
	public boolean isEmpty()
	{
		return this.map.isEmpty();
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#keySet()
	 */
	@SuppressWarnings("unchecked")
	public Set keySet()
	{
		return this.map.keySet();
	}

	public Map<String, Object> peekFieldStack()
	{
		return this.fieldValueStack.peek();
	}

	public Map<String, Object> popFieldStack()
	{
		return this.fieldValueStack.pop();
	}

	public void pushFieldStack(final Map<String, Object> fieldMap)
	{
		this.fieldValueStack.push(fieldMap);
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#put(java.lang.String,
	 *      java.lang.Object)
	 */
	public Object put(final String key, final Object value)
	{
		return this.map.put(key, value);
	}

	/**
	 * The content of Map specified by the argument is set to this context.
	 * 
	 * @param t
	 *            map
	 */
	public void putAll(final Map<? extends String, ? extends Object> t)
	{
		this.map.putAll(t);
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#remove(java.lang.Object)
	 */
	public Object remove(final Object key)
	{
		return this.map.remove(key);
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#size()
	 */
	public int size()
	{
		return this.map.size();
	}

	/**
	 * @see net.murakamin.sticker.StickerContext#values()
	 */
	public Collection<Object> values()
	{
		return this.map.values();
	}
}
