/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package net.murakamin.sticker;

/**
 * Thread class to receive shutdown event
 * 
 * @author Y.Murakamin
 * 
 */
public class ShutdownHook extends Thread
{
	private ShutdownEventHandler handler = null;

	/**
	 * constractor
	 * 
	 * @param shutdown
	 *            event handler
	 */
	public ShutdownHook(final ShutdownEventHandler shutdown)
	{
		super();
		this.handler = shutdown;
	}

	@Override
	public void run()
	{
		try
		{
			this.handler.shutdownEvent();
		} catch (Exception e)
		{
			throw new RuntimeException(e);
		}
	}
}
