/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.Commands;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.CursorCommand;
import net.murakamin.sticker.commands.ExecutableCommand;
import net.murakamin.sticker.commands.Messages;
import net.murakamin.sticker.commands.ParentCommand;
import net.murakamin.sticker.commands.VersionTerm;
import net.murakamin.sticker.commands.enums.PostChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.PreChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.TargetType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import org.apache.commons.lang.SystemUtils;

public class IfCommand
implements ParentCommand {
    Commands childlen = new Commands();
    private TargetType target = TargetType.remote;
    private String name;
    private String value;
    private boolean childExecute = false;

    @Override
    public void addChild(ExecutableCommand child) {
        this.childlen.add(child);
    }

    @Override
    public void execute(CommandRunner runner) throws Exception {
        ConnectionPool pool = runner.getConnectionPool();
        StickerContext context = runner.getStickerContext();
        this.childExecute = false;
        Connection con = pool.getLocalConnection();
        CursorCommand cursor = (CursorCommand)context.get(String.valueOf(CursorCommand.CURSOR_NAME_PREFIX) + this.getName());
        if (cursor == null) {
            throw new CommandExecutionException(String.valueOf(Messages.getString("net.murakamin.sticker.commands.CursorCommand.Corsor_not_found")) + this.getName());
        }
        if (this.target == TargetType.remote) {
            con = pool.getRemoteConnection();
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = con.createStatement();
                rs = stmt.executeQuery(cursor.getSql());
            }
            catch (SQLException se) {
                throw new CommandExecutionException((ExecutableCommand)this, String.valueOf(Messages.getString("net.murakamin.sticker.commands.CursorCommand.Cursor_open_failure")) + this.getName(), (Throwable)se);
            }
            ResultSetMetaData meta = rs.getMetaData();
            if (rs.next() && meta.getColumnCount() > 0 && this.getValue().equals(rs.getObject(1).toString())) {
                this.childExecute = true;
                runner.run(this);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
            rs = null;
        }
    }

    @Override
    public Commands getChildlen() {
        return this.childlen;
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target.name();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public VersionTerm getVersionTerm() {
        return new VersionTerm("0.1.3");
    }

    @Override
    public boolean isDebugPrint() {
        return false;
    }

    @Override
    public PostChildCommandExecutionType postChildCommandExecute(CommandRunner runner) throws Exception {
        return PostChildCommandExecutionType.NOT_REPEAT;
    }

    @Override
    public PreChildCommandExecutionType preChildCommandExecute(CommandRunner runner) throws Exception {
        return this.childExecute ? PreChildCommandExecutionType.CHILD_EXECUTE : PreChildCommandExecutionType.CHILD_NOT_EXECUTE;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTarget(String target) {
        this.target = TargetType.valueOf(target);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<if> : child execute ... ");
        buffer.append(this.childExecute);
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" cursor:");
        buffer.append(this.getName());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" target:");
        buffer.append(this.getTarget());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        return buffer.toString();
    }
}

