/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.Commands;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.ChildCommandExceptionHandler;
import net.murakamin.sticker.commands.DatabaseConnectionProperties;
import net.murakamin.sticker.commands.ExecutableCommand;
import net.murakamin.sticker.commands.ParentCommand;
import net.murakamin.sticker.commands.VersionTerm;
import net.murakamin.sticker.commands.enums.PostChildCommandExecutionType;
import net.murakamin.sticker.commands.enums.PreChildCommandExecutionType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import net.murakamin.sticker.commands.util.StickerContextUtil;

public class ConnectCommand
implements ParentCommand,
ChildCommandExceptionHandler {
    Commands childlen = new Commands();
    private String name;

    @Override
    public void addChild(ExecutableCommand child) {
        this.childlen.add(child);
    }

    @Override
    public void execute(CommandRunner runner) throws Exception {
        try {
            StickerContext context = runner.getStickerContext();
            DatabaseConnectionProperties props = (DatabaseConnectionProperties)context.get("CONTEXT_REMOTE_CONNECTION_PROP");
            Connection con = this.createConnection(context, props);
            con.setAutoCommit(props.getAutocommit());
            runner.getConnectionPool().setRemoteConnection(props.getName(), con);
            runner.run(this);
        }
        catch (Exception e) {
            throw new CommandExecutionException((ExecutableCommand)this, (Throwable)e);
        }
    }

    @Override
    public Commands getChildlen() {
        return this.childlen;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public VersionTerm getVersionTerm() {
        return VersionTerm.PERMANENT_COMMAND;
    }

    @Override
    public void handleException(CommandRunner runner) throws Exception {
        DatabaseConnectionProperties props = (DatabaseConnectionProperties)runner.getStickerContext().get("CONTEXT_REMOTE_CONNECTION_PROP");
        try {
            if (!props.getAutocommit()) {
                runner.getConnectionPool().getRemoteConnection().rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean isDebugPrint() {
        return true;
    }

    @Override
    public PostChildCommandExecutionType postChildCommandExecute(CommandRunner runner) throws Exception {
        DatabaseConnectionProperties props = (DatabaseConnectionProperties)runner.getStickerContext().get("CONTEXT_REMOTE_CONNECTION_PROP");
        try {
            if (!props.getAutocommit()) {
                runner.getConnectionPool().getRemoteConnection().rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        runner.getConnectionPool().setCurrentConnectionName(null);
        return PostChildCommandExecutionType.NOT_REPEAT;
    }

    @Override
    public PreChildCommandExecutionType preChildCommandExecute(CommandRunner runner) throws Exception {
        runner.getConnectionPool().setCurrentConnectionName(this.getName());
        return PreChildCommandExecutionType.CHILD_EXECUTE;
    }

    public void setName(String name) {
        this.name = name;
    }

    private Connection createConnection(StickerContext context, DatabaseConnectionProperties props) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        ClassLoader loader = this.getClass().getClassLoader();
        if (props.getDriverJarFile() != null) {
            String driverJarName = StickerContextUtil.applyContextVariable(context, props.getDriverJarFile());
            File driverFileName = new File(driverJarName).getCanonicalFile();
            URL driverURL = driverFileName.toURI().toURL();
            loader = URLClassLoader.newInstance(new URL[]{driverURL}, this.getClass().getClassLoader());
        }
        String driverName = StickerContextUtil.applyContextVariable(context, props.getDriver());
        String user = StickerContextUtil.applyContextVariable(context, props.getUser());
        String pass = StickerContextUtil.applyContextVariable(context, props.getPass());
        Class<?> driverClass = Class.forName(driverName, true, loader);
        Driver driverInstance = (Driver)driverClass.newInstance();
        Properties info = new Properties();
        info.put("user", user);
        info.put("password", pass);
        return driverInstance.connect(props.getUrl(), info);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<connect> connect to ");
        buffer.append(this.getName());
        buffer.append('.');
        return buffer.toString();
    }
}

