/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import java.util.regex.Pattern;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class StrRegExReplace
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final Pattern regexPattern;
    private final String replacement;

    public StrRegExReplace(String string, String string2) {
        this.handleArguments(string, string2);
        this.regexPattern = Pattern.compile(string);
        this.replacement = string2;
    }

    public StrRegExReplace(String string, String string2, BoolCellProcessor boolCellProcessor) {
        super(boolCellProcessor);
        this.handleArguments(string, string2);
        this.regexPattern = Pattern.compile(string);
        this.replacement = string2;
    }

    private void handleArguments(String string, String string2) {
        if (string == null) {
            throw new NullInputException("the regular expression cannot be null", this);
        }
        if (string2 == null) {
            throw new NullInputException("the replacement string cannot be null", this);
        }
        if (string.equals("")) {
            throw new SuperCSVException("the regular expression  cannot be \"\" as this has no effect", this);
        }
    }

    public Object execute(Object object, CSVContext cSVContext) {
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        String string = this.regexPattern.matcher((String)object).replaceAll(this.replacement);
        return this.next.execute(string, cSVContext);
    }
}

