/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.ClassCastInputCSVException;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class FmtBool
extends CellProcessorAdaptor
implements BoolCellProcessor {
    private final String trueValue;
    private final String falseValue;

    public FmtBool(String string, String string2) {
        this.trueValue = string;
        this.falseValue = string2;
    }

    public FmtBool(String string, String string2, StringCellProcessor stringCellProcessor) {
        super(stringCellProcessor);
        this.trueValue = string;
        this.falseValue = string2;
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (!(object instanceof Boolean)) {
            throw new ClassCastInputCSVException("the value '" + object + "' is not of type Boolean", cSVContext, this);
        }
        String string = (Boolean)object != false ? this.trueValue : this.falseValue;
        return this.next.execute(string, cSVContext);
    }
}

