/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import net.murakamin.csv.CSVParser;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.StickerCSVDataHandler;
import net.murakamin.sticker.commands.enums.TargetType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class ExportCommand
implements Command,
StickerCSVDataHandler {
    private final Log log = LogFactory.getLog(CommandRunner.class);
    private ConnectionPool conPool;
    private String destination;
    private String fileCharset = SystemUtils.FILE_ENCODING;
    private boolean header = true;
    private boolean overwrite = true;
    private char quot = '\u0000';
    private char separator = (char)44;
    private String sql = "";
    private TargetType target = TargetType.remote;
    private CsvListWriter writer;

    /*
     * Unable to fully structure code
     */
    public void addCSVData(String[] currentDatas) throws Exception {
        block15: {
            if (!this.conPool.existsLocalTable(this.getDestination())) {
                c = 0;
                while (c < currentDatas.length) {
                    if (currentDatas[c] == null) {
                        currentDatas[c] = "";
                    }
                    ++c;
                }
                this.writer.write(currentDatas);
            } else {
                sql = this.createInsertPrepareStatement(this.getDestination(), currentDatas);
                sql = sql.replaceAll("\n", " ");
                if ((sql = sql.replaceAll("\t", " ")).charAt(sql.length() - 1) == ';') {
                    sql = sql.substring(0, sql.length() - 1);
                }
                destConnection = this.conPool.getLocalConnection();
                stmt = destConnection.prepareStatement(sql);
                parameterIndex = 1;
                var9_7 = currentDatas;
                var8_10 = currentDatas.length;
                var7_12 = 0;
                while (var7_12 < var8_10) {
                    field = var9_7[var7_12];
                    stmt.setObject(parameterIndex, field);
                    ++parameterIndex;
                    ++var7_12;
                }
                if (Sticker.isDebug()) {
                    buffer = new StringBuffer();
                    var10_17 = currentDatas;
                    var9_8 = currentDatas.length;
                    var8_10 = 0;
                    while (var8_10 < var9_8) {
                        param = var10_17[var8_10];
                        buffer.append('[');
                        buffer.append(param);
                        buffer.append(']');
                        ++var8_10;
                    }
                    this.log.debug(stmt + ": parameters=" + buffer.toString());
                }
                try {
                    try {
                        stmt.execute();
                        break block15;
                    }
                    catch (Exception e) {
                        buffer = new StringBuffer();
                        var11_19 = currentDatas;
                        var10_18 = currentDatas.length;
                        var9_9 = 0;
                        ** while (var9_9 < var10_18)
                    }
lbl-1000:
                    // 1 sources

                    {
                        param = var11_19[var9_9];
                        buffer.append('[');
                        buffer.append(param);
                        buffer.append(']');
                        ++var9_9;
                        continue;
                    }
lbl62:
                    // 1 sources

                    this.log.error(buffer.toString());
                    throw e;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
    }

    private String createInsertPrepareStatement(String targetTable, String[] values) throws UnsupportedEncodingException {
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(targetTable);
        sql.append(" values (");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            sql.append('?');
            sql.append(',');
            ++n2;
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        return sql.toString();
    }

    public void execute(ConnectionPool pool, StickerContext context) throws Exception {
        this.conPool = pool;
        if (StringUtils.isEmpty(this.getSql().trim())) {
            throw new CommandExecutionException((Command)this, "SQL of the export is not defined.");
        }
        ResultSet rs = null;
        Statement stmt = null;
        try {
            try {
                Connection sourceConnection = this.conPool.getRemoteConnection();
                if (this.target == TargetType.local) {
                    sourceConnection = this.conPool.getLocalConnection();
                }
                stmt = sourceConnection.prepareStatement(this.getSql());
                rs = stmt.executeQuery();
                if (!this.conPool.existsLocalTable(this.getDestination())) {
                    CsvPreference pref = new CsvPreference(this.getQuot(), (int)this.getSeparator(), "\r\n");
                    File destFile = new File(this.getDestination());
                    this.writer = new CsvListWriter((Writer)new BufferedWriter(new FileWriter(destFile, !this.isOverwrite())), pref);
                    if (this.isHeader()) {
                        ResultSetMetaData rsMetaData = rs.getMetaData();
                        String[] header = new String[rsMetaData.getColumnCount()];
                        int c = 1;
                        while (c < rsMetaData.getColumnCount() + 1) {
                            header[c - 1] = rsMetaData.getColumnName(c);
                            ++c;
                        }
                        if (this.isOverwrite() || !new File(this.destination).exists()) {
                            this.writer.write(header);
                        }
                    }
                }
                new CSVParser(this).doParse(rs);
                if (!this.conPool.existsLocalTable(this.getDestination())) {
                    this.writer.close();
                }
            }
            catch (Exception e) {
                throw new CommandExecutionException((Command)this, (Throwable)e);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public String getFileCharset() {
        return this.fileCharset;
    }

    public char getQuot() {
        return this.quot;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getSql() {
        return this.sql;
    }

    public String getTarget() {
        return this.target.name();
    }

    public boolean isDebugPrint() {
        return true;
    }

    public boolean isHeader() {
        return this.header;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setFileCharset(String fileCharset) {
        this.fileCharset = fileCharset;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setQuot(char quot) {
        this.quot = quot;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setTarget(String target) {
        this.target = TargetType.valueOf(target);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<export> export execute:\n");
        buffer.append(" destination:");
        buffer.append(this.getDestination());
        buffer.append("\n");
        buffer.append(" target:");
        buffer.append(this.getTarget());
        buffer.append("\n");
        buffer.append(" header:");
        buffer.append(this.isHeader());
        buffer.append("\n");
        buffer.append(" separator:");
        buffer.append(this.getSeparator());
        buffer.append("\n");
        buffer.append(" quot:");
        buffer.append(this.getQuot() == '\u0000' ? "None" : Character.valueOf(this.getQuot()));
        buffer.append("\n");
        buffer.append(" charset:");
        buffer.append(this.getFileCharset());
        buffer.append("\n");
        buffer.append(" sql:");
        buffer.append(this.getSql());
        buffer.append("\n");
        return buffer.toString();
    }
}

