/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import net.murakamin.csv.CSVHeader;
import net.murakamin.csv.CSVHeaderMetaData;
import net.murakamin.csv.CSVParser;
import net.murakamin.csv.CSVReader;
import net.murakamin.csv.CSVWriter;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.StickerCSVDataHandler;
import net.murakamin.sticker.commands.enums.TargetType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportCommand
implements Command,
StickerCSVDataHandler {
    private final Log log = LogFactory.getLog(CommandRunner.class);
    private ConnectionPool conPool;
    private String destination;
    private String fileCharset = SystemUtils.FILE_ENCODING;
    private boolean header;
    private boolean overwrite;
    private char quot = CSVWriter.QUOTE_NONE;
    private char separator = (char)44;
    private String sql = "";
    private TargetType target = TargetType.remote;
    private CSVWriter writer;

    public void addCSVData(String[] currentDatas) throws Exception {
        if (!this.conPool.existsLocalTable(this.getDestination())) {
            this.writer.write(currentDatas);
        } else {
            String sql = this.createInsertPrepareStatement(this.getDestination(), currentDatas);
            sql = sql.replaceAll("\n", " ");
            if ((sql = sql.replaceAll("\t", " ")).charAt(sql.length() - 1) == ';') {
                sql = sql.substring(0, sql.length() - 1);
            }
            Connection destConnection = this.conPool.getLocalConnection();
            PreparedStatement stmt = destConnection.prepareStatement(sql);
            int parameterIndex = 1;
            String[] stringArray = currentDatas;
            int n = currentDatas.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                stmt.setObject(parameterIndex, field);
                ++parameterIndex;
                ++n2;
            }
            if (Sticker.isDebug()) {
                this.log.debug(stmt);
            }
            try {
                stmt.execute();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private String createInsertPrepareStatement(String targetTable, String[] values) throws UnsupportedEncodingException {
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(targetTable);
        sql.append(" values (");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            sql.append('?');
            sql.append(',');
            ++n2;
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        return sql.toString();
    }

    public void execute(ConnectionPool pool, StickerContext context) throws Exception {
        this.conPool = pool;
        if (StringUtils.isEmpty(this.getSql().trim())) {
            throw new CommandExecutionException((Command)this, "SQL of the export is not defined.");
        }
        ResultSet rs = null;
        Statement stmt = null;
        try {
            try {
                Connection sourceConnection = this.conPool.getRemoteConnection();
                if (this.target == TargetType.local) {
                    sourceConnection = this.conPool.getLocalConnection();
                }
                stmt = sourceConnection.prepareStatement(this.getSql());
                rs = stmt.executeQuery();
                if (!this.conPool.existsLocalTable(this.getDestination())) {
                    File destFile = new File(this.getDestination());
                    this.writer = new CSVWriter();
                    CSVHeader header = new CSVHeader();
                    ResultSetMetaData rsMetaData = rs.getMetaData();
                    int c = 1;
                    while (c < rsMetaData.getColumnCount() + 1) {
                        header.add(new CSVHeaderMetaData(rsMetaData.getColumnName(c), Class.forName(rsMetaData.getColumnClassName(c))));
                        ++c;
                    }
                    this.writer.setEncoding(this.getFileCharset());
                    this.writer.setFieldSeparator(this.getSeparator());
                    this.writer.setOverwrite(this.isOverwrite());
                    this.writer.setQuoteChar(this.getQuot());
                    this.writer.setSupportHeader(this.isHeader());
                    this.writer.open(destFile, header);
                }
                new CSVParser(this).doParse(rs);
                if (!this.conPool.existsLocalTable(this.getDestination())) {
                    this.writer.flush();
                    this.writer.close();
                }
            }
            catch (Exception e) {
                throw new CommandExecutionException((Command)this, (Throwable)e);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public String getFileCharset() {
        return this.fileCharset;
    }

    public char getQuot() {
        return this.quot;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getSql() {
        return this.sql;
    }

    public String getTarget() {
        return this.target.name();
    }

    public boolean isDebugPrint() {
        return true;
    }

    public boolean isHeader() {
        return this.header;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setFileCharset(String fileCharset) {
        this.fileCharset = fileCharset;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setQuot(char quot) {
        this.quot = quot;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setTarget(String target) {
        this.target = TargetType.valueOf(target);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<export> export execute:\n");
        buffer.append(" destination:");
        buffer.append(this.getDestination());
        buffer.append("\n");
        buffer.append(" target:");
        buffer.append(this.getTarget());
        buffer.append("\n");
        buffer.append(" header:");
        buffer.append(this.isHeader());
        buffer.append("\n");
        buffer.append(" separator:");
        buffer.append(this.getSeparator());
        buffer.append("\n");
        buffer.append(" quot:");
        buffer.append(this.getQuot() == CSVReader.QUOTE_NONE ? "None" : Character.valueOf(this.getQuot()));
        buffer.append("\n");
        buffer.append(" charset:");
        buffer.append(this.getFileCharset());
        buffer.append("\n");
        buffer.append(" sql:");
        buffer.append(this.getSql());
        buffer.append("\n");
        return buffer.toString();
    }
}

