/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import net.murakamin.csv.CSVDataHandler;
import net.murakamin.csv.CSVParser;
import net.murakamin.csv.CSVReader;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.enums.TargetType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportCommand
implements Command,
CSVDataHandler {
    private final Log log = LogFactory.getLog(CommandRunner.class);
    private ConnectionPool conPool;
    private String destination;
    private String fileCharset = SystemUtils.FILE_ENCODING;
    private boolean header;
    private String labe;
    private char quot = CSVReader.QUOTE_NONE;
    private char separator = (char)44;
    private String source;
    private TargetType target = TargetType.remote;

    public void addCSVData(String[] currentDatas) throws Exception {
        String sql = this.createInsertPrepareStatement(this.getDestination(), currentDatas);
        PreparedStatement stmt = null;
        Connection targetConnection = null;
        targetConnection = TargetType.local == this.target ? this.conPool.getLocalConnection() : this.conPool.getRemoteConnection();
        stmt = targetConnection.prepareStatement(sql);
        int parameterIndex = 1;
        String[] stringArray = currentDatas;
        int n = currentDatas.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            stmt.setObject(parameterIndex, field);
            ++parameterIndex;
            ++n2;
        }
        if (Sticker.isDebug()) {
            this.log.debug(stmt);
        }
        try {
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private String createInsertPrepareStatement(String targetTable, String[] values) throws UnsupportedEncodingException {
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(targetTable);
        sql.append(" values (");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            sql.append('?');
            sql.append(',');
            ++n2;
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        return sql.toString();
    }

    public void execute(ConnectionPool pool, StickerContext context) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                this.conPool = pool;
                if (!pool.existsLocalTable(this.getSource())) {
                    new CSVParser(this).doParse(new File(this.getSource()));
                } else {
                    Connection sourceConnection = null;
                    String sourceTableName = null;
                    sourceConnection = this.conPool.getLocalConnection();
                    sourceTableName = this.getSource();
                    stmt = sourceConnection.prepareStatement("select * from " + sourceTableName);
                    rs = stmt.executeQuery();
                    new CSVParser(this).doParse(rs);
                }
            }
            catch (Exception e) {
                throw new CommandExecutionException((Command)this, (Throwable)e);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public String getFileCharset() {
        return this.fileCharset;
    }

    public String getLabe() {
        return this.labe;
    }

    public char getQuot() {
        return this.quot;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target.name();
    }

    public boolean isDebugPrint() {
        return true;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setFileCharset(String charset) {
        this.fileCharset = charset;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setLabe(String labe) {
        this.labe = labe;
    }

    public void setQuot(char quot) {
        this.quot = quot;
    }

    public void setSeparator(char separatorType) {
        this.separator = separatorType;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String t) {
        this.target = TargetType.valueOf(t);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<import> import execute:\n");
        buffer.append(" source:");
        buffer.append(this.getSource());
        buffer.append("\n");
        buffer.append(" destination:");
        buffer.append(this.getDestination());
        buffer.append("\n");
        buffer.append(" target:");
        buffer.append(this.getTarget());
        buffer.append("\n");
        buffer.append(" header:");
        buffer.append(this.isHeader());
        buffer.append("\n");
        buffer.append(" separator:");
        buffer.append(this.getSeparator());
        buffer.append("\n");
        buffer.append(" quot:");
        buffer.append(this.getQuot() == CSVReader.QUOTE_NONE ? "None" : Character.valueOf(this.getQuot()));
        buffer.append("\n");
        buffer.append(" charset:");
        buffer.append(this.getFileCharset());
        buffer.append("\n");
        return buffer.toString();
    }
}

