/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.argius.stew.Logger;
import net.argius.stew.io.CsvFormatter;
import net.argius.stew.io.Importer;
import net.argius.stew.io.SmartImporter;
import net.argius.stew.text.TextUtilities;
import net.argius.stew.ui.window.AnyAction;
import net.argius.stew.ui.window.AnyActionEvent;
import net.argius.stew.ui.window.AnyActionKey;
import net.argius.stew.ui.window.AnyActionListener;
import net.argius.stew.ui.window.ClipboardHelper;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.TextSearch;
import net.argius.stew.ui.window.Utilities;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class ResultSetTable
extends JTable
implements AnyActionListener,
TextSearch {
    static final String TAB = "\t";
    private static final Logger log = Logger.getLogger(ResultSetTable.class);
    private static final TableCellRenderer nullRenderer = new NullValueRenderer();
    private final AnyActionListener anyActionListener;
    private final ColumnHeaderCellRenderer columnHeaderRenderer;
    private final RowHeader rowHeader;
    private final Point mousePositionForColumnHeader = new Point();
    private int lastSortedIndex;
    private boolean lastSortedIsReverse;
    private String autoAdjustMode;
    private volatile KeyEvent lastKeyEvent;

    ResultSetTable(AnyActionListener anyActionListener) {
        int n;
        this.anyActionListener = anyActionListener;
        JTableHeader jTableHeader = this.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        RowHeader rowHeader = new RowHeader(this);
        this.columnHeaderRenderer = new ColumnHeaderCellRenderer(tableCellRenderer);
        this.rowHeader = rowHeader;
        this.setColumnSelectionAllowed(true);
        this.setAutoResizeMode(0);
        jTableHeader.setDefaultRenderer(this.columnHeaderRenderer);
        jTableHeader.setReorderingAllowed(false);
        ColumnHeaderMouseInputListener columnHeaderMouseInputListener = new ColumnHeaderMouseInputListener();
        jTableHeader.addMouseListener(columnHeaderMouseInputListener);
        jTableHeader.addMouseMotionListener(columnHeaderMouseInputListener);
        RowHeaderMouseInputListener rowHeaderMouseInputListener = new RowHeaderMouseInputListener(rowHeader);
        rowHeader.addMouseListener(rowHeaderMouseInputListener);
        rowHeader.addMouseMotionListener(rowHeaderMouseInputListener);
        for (n = 0; n < 2; ++n) {
            boolean bl = n == 1;
            this.bindJumpAction("home", 36, bl);
            this.bindJumpAction("end", 35, bl);
            this.bindJumpAction("top", 38, bl);
            this.bindJumpAction("bottom", 40, bl);
            this.bindJumpAction("leftmost", 37, bl);
            this.bindJumpAction("rightmost", 39, bl);
        }
        n = Utilities.getMenuShortcutKeyMask();
        AnyAction anyAction = new AnyAction(this);
        anyAction.bindSelf((Object)AnyActionKey.paste, KeyStroke.getKeyStroke(86, n));
        anyAction.bindKeyStroke(true, (Object)AnyActionKey.adjustColumnWidth, KeyStroke.getKeyStroke(47, n));
        anyAction.bindKeyStroke(false, (Object)ActionKey.doNothing, KeyStroke.getKeyStroke(27, 0));
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        this.lastKeyEvent = keyEvent;
    }

    @Override
    public void anyActionPerformed(AnyActionEvent anyActionEvent) {
        try {
            this.processAnyActionEvent(anyActionEvent);
        }
        catch (Exception exception) {
            WindowOutputProcessor.showErrorDialog(this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnyActionEvent(AnyActionEvent anyActionEvent) throws Exception {
        block74: {
            if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.copy, AnyActionKey.selectAll})) {
                String string = anyActionEvent.getActionCommand();
                this.getActionMap().get(string).actionPerformed(new ActionEvent(this, 0, string));
            } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.copyWithEscape})) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int n : this.getSelectedRows()) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (int n2 : this.getSelectedColumns()) {
                        Object object = this.getValueAt(n, n2);
                        arrayList2.add(CsvFormatter.AUTO.format(object == null ? "" : String.valueOf(object)));
                    }
                    arrayList.add(TextUtilities.join(TAB, arrayList2));
                }
                ClipboardHelper.setStrings(arrayList);
            } else {
                if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.paste})) {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ClipboardHelper.getString().getBytes());
                        SmartImporter smartImporter = new SmartImporter(byteArrayInputStream, TAB);
                        try {
                            int[] nArray = this.getSelectedColumns();
                            for (int n : this.getSelectedRows()) {
                                Object[] objectArray = ((Importer)smartImporter).nextRow();
                                int n3 = Math.min(nArray.length, objectArray.length);
                                for (int i = 0; i < n3; ++i) {
                                    this.setValueAt(objectArray[i], n, nArray[i]);
                                }
                            }
                        }
                        finally {
                            ((Importer)smartImporter).close();
                        }
                        this.repaint();
                    }
                    finally {
                        this.editingCanceled(new ChangeEvent(anyActionEvent.getSource()));
                    }
                }
                if (anyActionEvent.isAnyOf(new Object[]{ActionKey.clearSelectedCellValue})) {
                    try {
                        this.setValueAtSelectedCells(null);
                        this.repaint();
                    }
                    finally {
                        this.editingCanceled(new ChangeEvent(anyActionEvent.getSource()));
                    }
                }
                if (anyActionEvent.isAnyOf(new Object[]{ActionKey.setCurrentTimeValue})) {
                    try {
                        this.setValueAtSelectedCells(new Timestamp(System.currentTimeMillis()));
                        this.repaint();
                    }
                    finally {
                        this.editingCanceled(new ChangeEvent(anyActionEvent.getSource()));
                    }
                }
                if (anyActionEvent.isAnyOf(new Object[]{ActionKey.copyColumnName})) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ResultSetTableModel resultSetTableModel = this.getResultSetTableModel();
                    if (anyActionEvent.getModifiers() == 0) {
                        int n = resultSetTableModel.getColumnCount();
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(resultSetTableModel.getColumnName(i));
                        }
                    } else {
                        for (int n : this.getSelectedColumns()) {
                            arrayList.add(resultSetTableModel.getColumnName(n));
                        }
                    }
                    ClipboardHelper.setString(TextUtilities.join(TAB, arrayList));
                } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.findColumnName})) {
                    this.anyActionListener.anyActionPerformed(anyActionEvent);
                } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.addEmptyRow})) {
                    ResultSetTableModel resultSetTableModel = this.getResultSetTableModel();
                    int[] nArray = this.getSelectedRows();
                    if (nArray.length > 0) {
                        int n = nArray[nArray.length - 1] + 1;
                        for (int i = 0; i < nArray.length; ++i) {
                            resultSetTableModel.insertUnlinkedRow(n, new Object[resultSetTableModel.getColumnCount()]);
                        }
                    } else {
                        resultSetTableModel.addUnlinkedRow(new Object[resultSetTableModel.getColumnCount()]);
                    }
                } else {
                    if (anyActionEvent.isAnyOf(new Object[]{ActionKey.insertFromClipboard})) {
                        try {
                            SmartImporter smartImporter = new SmartImporter(ClipboardHelper.getReaderForText(), TAB);
                            try {
                                Object[] objectArray;
                                ResultSetTableModel resultSetTableModel = this.getResultSetTableModel();
                                while ((objectArray = ((Importer)smartImporter).nextRow()).length != 0) {
                                    resultSetTableModel.addUnlinkedRow(objectArray);
                                    resultSetTableModel.linkRow(resultSetTableModel.getRowCount() - 1);
                                }
                                this.repaintRowHeader("model");
                                break block74;
                            }
                            finally {
                                ((Importer)smartImporter).close();
                            }
                        }
                        finally {
                            this.editingCanceled(new ChangeEvent(anyActionEvent.getSource()));
                        }
                    }
                    if (anyActionEvent.isAnyOf(new Object[]{ActionKey.duplicateRows})) {
                        ResultSetTableModel resultSetTableModel = this.getResultSetTableModel();
                        Vector<Vector> vector = resultSetTableModel.getDataVector();
                        int[] nArray = this.getSelectedRows();
                        int n = nArray[nArray.length - 1];
                        for (int n4 : nArray) {
                            resultSetTableModel.insertUnlinkedRow(++n, (Vector)((Vector)vector.get(n4)).clone());
                        }
                        this.repaint();
                        this.repaintRowHeader("model");
                    } else {
                        if (anyActionEvent.isAnyOf(new Object[]{ActionKey.linkRowsToDatabase})) {
                            ResultSetTableModel resultSetTableModel = this.getResultSetTableModel();
                            try {
                                for (int n : this.getSelectedRows()) {
                                    resultSetTableModel.linkRow(n);
                                }
                            }
                            finally {
                                this.repaintRowHeader("unlinkedRowStatus");
                            }
                        }
                        if (anyActionEvent.isAnyOf(new Object[]{ActionKey.deleteRows})) {
                            try {
                                ResultSetTableModel resultSetTableModel = this.getResultSetTableModel();
                                while (true) {
                                    int n;
                                    if ((n = this.getSelectedRow()) < 0) {
                                        break block74;
                                    }
                                    if (resultSetTableModel.isLinkedRow(n)) {
                                        boolean bl = resultSetTableModel.removeLinkedRow(n);
                                        assert (bl);
                                        continue;
                                    }
                                    resultSetTableModel.removeRow(n);
                                }
                            }
                            finally {
                                this.repaintRowHeader("model");
                            }
                        }
                        if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.adjustColumnWidth})) {
                            this.adjustColumnWidth();
                        } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.widenColumnWidth})) {
                            this.changeTableColumnWidth(1.5);
                        } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.narrowColumnWidth})) {
                            this.changeTableColumnWidth(0.6666666865348816);
                        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.sort})) {
                            this.doSort(this.getTableHeader().columnAtPoint(this.mousePositionForColumnHeader));
                        } else if (anyActionEvent.isAnyOf(new Object[]{ActionKey.jumpToColumn})) {
                            Object[] objectArray = anyActionEvent.getArgs();
                            if (objectArray != null && objectArray.length > 0) {
                                this.jumpToColumn(String.valueOf(objectArray[0]));
                            }
                        } else if (anyActionEvent.isAnyOf(new Object[]{AnyActionKey.showColumnNumber})) {
                            this.setShowColumnNumber(!this.columnHeaderRenderer.fixesColumnNumber);
                            this.updateUI();
                        } else {
                            log.warn("not expected: Event=%s", anyActionEvent);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        try {
            super.editingStopped(changeEvent);
        }
        catch (Exception exception) {
            WindowOutputProcessor.showErrorDialog(this.getParent(), exception);
        }
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.editorComp instanceof JTextField && this.lastKeyEvent != null && this.lastKeyEvent.getKeyCode() != 113) {
            JTextField jTextField = (JTextField)this.editorComp;
            this.initializeEditorComponent(jTextField);
            jTextField.requestFocus();
            jTextField.selectAll();
        }
        return bl;
    }

    @Override
    public TableCellEditor getCellEditor() {
        TableCellEditor tableCellEditor = super.getCellEditor();
        if (tableCellEditor instanceof DefaultCellEditor) {
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableCellEditor;
            this.initializeEditorComponent(defaultCellEditor.getComponent());
        }
        return tableCellEditor;
    }

    private void initializeEditorComponent(Component component) {
        Color color = Color.ORANGE;
        if (component != null && component.getBackground() != color) {
            if (!component.isEnabled()) {
                component.setEnabled(true);
            }
            component.setFont(this.getFont());
            component.setBackground(color);
            if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                AnyAction anyAction = new AnyAction(jTextComponent);
                anyAction.setUndoAction();
                component.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        ResultSetTable.this.editingCanceled(new ChangeEvent(focusEvent.getSource()));
                    }
                });
            }
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        if (object == null) {
            return nullRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ResultSetTable.adjustRowHeight(this);
    }

    static void adjustRowHeight(JTable jTable) {
        JLabel jLabel = new JLabel("0");
        int n = ((Component)jLabel).getPreferredSize().height;
        if (n > 0) {
            jTable.setRowHeight(n);
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container container;
        super.configureEnclosingScrollPane();
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setRowHeaderView(this.rowHeader);
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        tableModel.addTableModelListener(this.rowHeader);
        super.setModel(tableModel);
    }

    void selectColumn(int n, int n2) {
        if (this.getRowCount() > 0) {
            this.addColumnSelectionInterval(n, n2);
            this.addRowSelectionInterval(this.getRowCount() - 1, 0);
        }
    }

    boolean jumpToColumn(int n) {
        int n2 = this.getColumnCount();
        if (0 <= n && n < n2) {
            if (this.getSelectedRowCount() == 0) {
                this.changeSelection(-1, n, false, false);
            } else {
                int[] nArray = this.getSelectedRows();
                this.changeSelection(this.getSelectedRow(), n, false, false);
                for (int n3 : nArray) {
                    this.changeSelection(n3, n, false, true);
                }
            }
            return true;
        }
        return false;
    }

    boolean jumpToColumn(String string) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(String.valueOf(tableColumnModel.getColumn(i).getHeaderValue()))) continue;
            this.jumpToColumn(i);
            return true;
        }
        return false;
    }

    RowHeader getRowHeader() {
        return this.rowHeader;
    }

    ResultSetTableModel getResultSetTableModel() {
        return (ResultSetTableModel)this.getModel();
    }

    boolean isShowColumnNumber() {
        return this.columnHeaderRenderer.fixesColumnNumber;
    }

    void setShowColumnNumber(boolean bl) {
        boolean bl2 = this.columnHeaderRenderer.fixesColumnNumber;
        this.columnHeaderRenderer.fixesColumnNumber = bl;
        this.firePropertyChange("showNumber", bl2, bl);
    }

    void repaintRowHeader(String string) {
        if (this.rowHeader != null) {
            this.rowHeader.propertyChange(new PropertyChangeEvent(this, string, null, null));
        }
    }

    String getAutoAdjustMode() {
        return this.autoAdjustMode;
    }

    void setAutoAdjustMode(String string) {
        String string2 = this.autoAdjustMode;
        this.autoAdjustMode = string;
        this.firePropertyChange("autoAdjustMode", string2, string);
    }

    private void bindJumpAction(String string, int n, boolean bl) {
        String string2 = String.format("%s-to-%s", bl ? "select" : "jump", string);
        CellCursor cellCursor = new CellCursor(this, bl);
        int n2 = Utilities.getMenuShortcutKeyMask() | (bl ? 64 : 0);
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(n, n2)};
        cellCursor.putValue("ActionCommandKey", string2);
        InputMap inputMap = this.getInputMap();
        for (KeyStroke keyStroke : keyStrokeArray) {
            inputMap.put(keyStroke, string2);
        }
        this.getActionMap().put(string2, cellCursor);
    }

    @Override
    public boolean search(TextSearch.Matcher matcher) {
        int n = this.getRowCount();
        if (n <= 0) {
            return false;
        }
        int n2 = this.getColumnCount();
        boolean bl = matcher.isBackward();
        int n3 = bl ? -1 : 1;
        int n4 = bl ? n - 1 : 0;
        int n5 = bl ? 0 : n - 1;
        int n6 = bl ? n2 - 1 : 0;
        int n7 = bl ? 0 : n2 - 1;
        int n8 = n4;
        int n9 = n6;
        if (this.getSelectedColumnCount() > 0) {
            n9 = this.getSelectedColumn();
            n8 = this.getSelectedRow() + n3;
            if (bl) {
                if (n8 < 0) {
                    if (--n9 < 0) {
                        return false;
                    }
                    n8 = n4;
                }
            } else if (n8 >= n) {
                if (++n9 >= n2) {
                    return false;
                }
                n8 = n4;
            }
        }
        TableModel tableModel = this.getModel();
        while (bl ? n9 >= n7 : n9 <= n7) {
            while (bl ? n8 >= n5 : n8 <= n5) {
                if (matcher.find(String.valueOf(tableModel.getValueAt(n8, n9)))) {
                    this.changeSelection(n8, n9, false, false);
                    return true;
                }
                n8 += n3;
            }
            n8 = n4;
            n9 += n3;
        }
        return false;
    }

    @Override
    public void reset() {
    }

    private void setValueAtSelectedCells(Object object) {
        int[] nArray = this.getSelectedColumns();
        for (int n : this.getSelectedRows()) {
            for (int n2 : nArray) {
                this.setValueAt(object, n, n2);
            }
        }
    }

    private void adjustColumnWidth() {
        boolean bl;
        boolean bl2;
        int n = this.getRowCount();
        switch (AnyActionKey.of(this.autoAdjustMode)) {
            case autoAdjustModeNone: {
                bl2 = false;
                bl = false;
                break;
            }
            case autoAdjustModeHeader: {
                bl2 = true;
                bl = false;
                break;
            }
            case autoAdjustModeValue: {
                bl2 = false;
                bl = true;
                break;
            }
            case autoAdjustModeHeaderAndValue: {
                bl2 = true;
                bl = true;
                break;
            }
            default: {
                log.warn("autoAdjustMode=%s", this.autoAdjustMode);
                return;
            }
        }
        if (!bl2 && n == 0) {
            return;
        }
        float f = (float)this.getParent().getWidth() * 0.8f;
        TableColumnModel tableColumnModel = this.getColumnModel();
        JTableHeader jTableHeader = this.getTableHeader();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            TableCellRenderer tableCellRenderer;
            float f2 = 0.0f;
            if (bl2) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                }
                if (tableCellRenderer != null) {
                    object = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, i);
                    f2 = (float)((Component)object).getPreferredSize().width * 1.5f;
                }
            }
            if (bl) {
                for (int j = 0; j < n; ++j) {
                    tableCellRenderer = this.getCellRenderer(j, i);
                    if (tableCellRenderer == null) continue;
                    object = this.getValueAt(j, i);
                    Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, j, i);
                    if ((f2 = Math.max(f2, (float)component.getPreferredSize().width)) >= f) break;
                }
            }
            int n3 = Math.round(f2 > f ? f : f2) + 1;
            tableColumnModel.getColumn(i).setPreferredWidth(n3);
        }
    }

    void doSort(int n) {
        boolean bl;
        if (this.getColumnCount() == 0) {
            return;
        }
        if (this.lastSortedIndex == n) {
            bl = !this.lastSortedIsReverse;
        } else {
            this.lastSortedIndex = n;
            bl = false;
        }
        this.lastSortedIsReverse = bl;
        this.getResultSetTableModel().sort(n, bl);
        this.repaint();
        this.repaintRowHeader("unlinkedRowStatus");
    }

    void changeTableColumnWidth(double d) {
        for (TableColumn tableColumn : Collections.list(this.getColumnModel().getColumns())) {
            tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * d));
        }
    }

    static final class TableHeaderTextSearch
    implements TextSearch {
        private ResultSetTable rstable;
        private JTableHeader tableHeader;

        TableHeaderTextSearch(ResultSetTable resultSetTable, JTableHeader jTableHeader) {
            this.rstable = resultSetTable;
            this.tableHeader = jTableHeader;
        }

        @Override
        public boolean search(TextSearch.Matcher matcher) {
            TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
            int n = tableColumnModel.getColumnCount();
            if (n < 1) {
                return false;
            }
            boolean bl = matcher.isBackward();
            int n2 = bl ? -1 : 1;
            int n3 = bl ? n - 1 : 0;
            int n4 = bl ? 0 : n - 1;
            int n5 = n3;
            if (this.rstable.getSelectedColumnCount() > 0) {
                n5 = this.rstable.getSelectedColumn() + n2;
            }
            while (bl ? n5 >= n4 : n5 <= n4) {
                if (matcher.find(String.valueOf(tableColumnModel.getColumn(n5).getHeaderValue()))) {
                    this.rstable.jumpToColumn(n5);
                    return true;
                }
                n5 += n2;
            }
            return false;
        }

        @Override
        public void reset() {
        }
    }

    private static final class RowHeader
    extends JTable
    implements PropertyChangeListener {
        private static final int DEFAULT_WIDTH = 40;
        private DefaultTableModel model = new DefaultTableModel(0, 1){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        private TableCellRenderer renderer;

        RowHeader(JTable jTable) {
            final ResultSetTable resultSetTable = (ResultSetTable)jTable;
            this.renderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    assert (resultSetTable.getModel() instanceof ResultSetTableModel);
                    boolean bl3 = resultSetTable.getResultSetTableModel().isLinkedRow(n);
                    JLabel jLabel = new JLabel(String.format("%s ", bl3 ? Integer.valueOf(n + 1) : "+"));
                    jLabel.setHorizontalAlignment(4);
                    jLabel.setFont(jTable.getFont());
                    jLabel.setOpaque(true);
                    return jLabel;
                }
            };
            this.setModel(this.model);
            this.setWidth(jTable);
            this.setFocusable(false);
            jTable.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTable jTable = (JTable)propertyChangeEvent.getSource();
            if (jTable == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("enabled")) {
                boolean bl = jTable.isEnabled();
                this.setVisible(bl);
                if (bl) {
                    this.setWidth(jTable);
                    this.resetViewPosition(jTable);
                }
            } else if (string.equals("font")) {
                this.setFont(jTable.getFont());
            } else if (string.equals("rowHeight")) {
                this.setRowHeight(jTable.getRowHeight());
            } else if (string.equals("model")) {
                this.model.setRowCount(jTable.getRowCount());
            } else if (string.equals("unlinkedRowStatus")) {
                this.repaint();
            } else if (string.equals("ancestor")) {
                // empty if block
            }
            this.validate();
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            Object object = tableModelEvent.getSource();
            if (this.model != null && object != null) {
                this.model.setRowCount(((TableModel)object).getRowCount());
            }
            super.tableChanged(tableModelEvent);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            ResultSetTable.adjustRowHeight(this);
        }

        void setWidth(JTable jTable) {
            int n = jTable.getRowCount();
            this.model.setRowCount(n);
            JLabel jLabel = new JLabel(String.valueOf((long)n * 1000L));
            Dimension dimension = this.getSize();
            dimension.width = Math.max(jLabel.getPreferredSize().width, 40);
            this.setPreferredScrollableViewportSize(dimension);
        }

        private void resetViewPosition(JTable jTable) {
            Container container = jTable.getParent();
            Container container2 = this.getParent();
            if (container instanceof JViewport && container2 instanceof JViewport) {
                JViewport jViewport = (JViewport)container;
                JViewport jViewport2 = (JViewport)container2;
                jViewport2.setViewPosition(jViewport.getViewPosition());
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return this.renderer;
        }
    }

    private static final class ColumnHeaderCellRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        boolean fixesColumnNumber;

        ColumnHeaderCellRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
            this.fixesColumnNumber = false;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = this.fixesColumnNumber ? String.format("%d %s", n2 + 1, object) : object;
            return this.renderer.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        }
    }

    private static final class NullValueRenderer
    extends DefaultTableCellRenderer {
        NullValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, "NULL", bl, bl2, n, n2);
            component.setForeground(new Color(63, 63, 192, 192));
            Font font = component.getFont();
            component.setFont(font.deriveFont((float)font.getSize() * 0.8f));
            return component;
        }
    }

    private static final class CellCursor
    extends AbstractAction {
        private final JTable table;
        private final boolean extend;

        CellCursor(JTable jTable, boolean bl) {
            this.table = jTable;
            this.extend = bl;
        }

        int getColumnPosition() {
            int[] nArray = this.table.getSelectedColumns();
            if (nArray == null || nArray.length == 0) {
                return -1;
            }
            ListSelectionModel listSelectionModel = this.table.getColumnModel().getSelectionModel();
            return nArray[0] == listSelectionModel.getAnchorSelectionIndex() ? nArray[nArray.length - 1] : nArray[0];
        }

        int getRowPosition() {
            int[] nArray = this.table.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return -1;
            }
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            return nArray[0] == listSelectionModel.getAnchorSelectionIndex() ? nArray[nArray.length - 1] : nArray[0];
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            String string = actionEvent.getActionCommand();
            if (string == null) {
                assert (false) : "command is null";
                return;
            }
            if (string.endsWith("-to-home")) {
                n2 = 0;
                n = 0;
            } else if (string.endsWith("-to-end")) {
                n2 = this.table.getRowCount() - 1;
                n = this.table.getColumnCount() - 1;
            } else if (string.endsWith("-to-top")) {
                n2 = 0;
                n = this.getColumnPosition();
            } else if (string.endsWith("-to-bottom")) {
                n2 = this.table.getRowCount() - 1;
                n = this.getColumnPosition();
            } else if (string.endsWith("-to-leftmost")) {
                n2 = this.getRowPosition();
                n = 0;
            } else if (string.endsWith("-to-rightmost")) {
                n2 = this.getRowPosition();
                n = this.table.getColumnCount() - 1;
            } else {
                assert (false) : "unknown command: " + string;
                return;
            }
            this.table.changeSelection(n2, n, false, this.extend);
        }
    }

    private final class ColumnHeaderMouseInputListener
    extends MouseInputAdapter {
        private int dragStartColumn;

        ColumnHeaderMouseInputListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.changeSelection(mouseEvent);
            }
            ResultSetTable.this.mousePositionForColumnHeader.setLocation(mouseEvent.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.changeSelection(mouseEvent);
            }
        }

        private void changeSelection(MouseEvent mouseEvent) {
            boolean bl;
            Point point = mouseEvent.getPoint();
            int n = mouseEvent.getID();
            boolean bl2 = n == 501;
            boolean bl3 = bl = n == 506;
            if (bl2 || bl) {
                int n2;
                int n3;
                int n4;
                if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                    ResultSetTable.this.clearSelection();
                }
                if ((n4 = ResultSetTable.this.columnAtPoint(point)) < 0 || ResultSetTable.this.getColumnCount() <= n4) {
                    return;
                }
                if (bl2) {
                    if (mouseEvent.isShiftDown()) {
                        n3 = this.dragStartColumn;
                        n2 = n4;
                    } else {
                        this.dragStartColumn = n4;
                        n3 = n4;
                        n2 = n4;
                    }
                } else if (bl) {
                    n3 = this.dragStartColumn;
                    n2 = n4;
                } else {
                    return;
                }
                ResultSetTable.this.selectColumn(n3, n2);
                ResultSetTable.this.requestFocus();
            }
        }
    }

    private final class RowHeaderMouseInputListener
    extends MouseInputAdapter {
        private final RowHeader rowHeader;
        private int dragStartRow;

        RowHeaderMouseInputListener(RowHeader rowHeader) {
            this.rowHeader = rowHeader;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.changeSelection(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.changeSelection(mouseEvent);
        }

        private void changeSelection(MouseEvent mouseEvent) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                boolean bl;
                int n = mouseEvent.getID();
                boolean bl2 = n == 501;
                boolean bl3 = bl = n == 506;
                if (bl2 || bl) {
                    int n2;
                    int n3;
                    int n4;
                    if (point.y >= this.rowHeader.getBounds().height) {
                        return;
                    }
                    if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                        ResultSetTable.this.clearSelection();
                    }
                    if ((n4 = ResultSetTable.this.rowAtPoint(point)) < 0 || ResultSetTable.this.getRowCount() < n4) {
                        return;
                    }
                    if (bl2) {
                        if (mouseEvent.isShiftDown()) {
                            n3 = this.dragStartRow;
                            n2 = n4;
                        } else {
                            this.dragStartRow = n4;
                            n3 = n4;
                            n2 = n4;
                        }
                    } else if (bl) {
                        n3 = this.dragStartRow;
                        n2 = n4;
                    } else {
                        return;
                    }
                    ResultSetTable.this.addRowSelectionInterval(n3, n2);
                    ResultSetTable.this.addColumnSelectionInterval(ResultSetTable.this.getColumnCount() - 1, 0);
                    ResultSetTable.this.requestFocus();
                    JViewport jViewport = (JViewport)ResultSetTable.this.getParent();
                    Point point2 = jViewport.getViewPosition();
                    point2.y = ((JViewport)this.rowHeader.getParent()).getViewPosition().y;
                    jViewport.setViewPosition(point2);
                }
            }
        }
    }

    static enum ActionKey {
        copyWithEscape,
        clearSelectedCellValue,
        setCurrentTimeValue,
        copyColumnName,
        findColumnName,
        addEmptyRow,
        insertFromClipboard,
        duplicateRows,
        linkRowsToDatabase,
        deleteRows,
        sort,
        jumpToColumn,
        doNothing;

    }
}

