/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.argius.stew.io.ExporterFactory;
import net.argius.stew.io.Path;

public abstract class Exporter {
    protected OutputStream os;
    protected boolean wasWrittenHeader;
    private boolean closed;

    protected Exporter(OutputStream outputStream) {
        this.os = outputStream;
        this.wasWrittenHeader = false;
    }

    protected final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public void addHeader(Object[] objectArray) throws IOException {
        this.ensureOpen();
        if (this.wasWrittenHeader) {
            throw new IOException("header was already written");
        }
        this.writeHeader(objectArray);
        this.wasWrittenHeader = true;
    }

    protected void writeHeader(Object[] objectArray) throws IOException {
        this.ensureOpen();
        this.addRow(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.ensureOpen();
        if (this.os != null) {
            try {
                this.os.close();
            }
            finally {
                this.os = null;
            }
        }
    }

    public static Exporter getExporter(File file) throws IOException {
        return ExporterFactory.createExporter(new Path(file));
    }

    public static Exporter getExporter(String string) throws IOException {
        return ExporterFactory.createExporter(new Path(string));
    }

    public abstract void addRow(Object[] var1) throws IOException;
}

