/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.security.*;

import javax.crypto.*;
import javax.crypto.spec.*;

/**
 * PBEɂÍgppX[hB
 */
public final class PbePassword extends CipherPassword {

    private static final String TRANSFORMATION_NAME = "PBEWithMD5AndDES";
    private static final byte[] SALT = "0141STEW".getBytes();
    private static final int ITERATION = 10;

    @Override
    protected Cipher getCipherInstance(String code, int mode) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(code.toCharArray());
            SecretKey key = SecretKeyFactory.getInstance(TRANSFORMATION_NAME)
                                            .generateSecret(keySpec);
            PBEParameterSpec spec = new PBEParameterSpec(SALT, ITERATION);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_NAME);
            cipher.init(mode, key, spec);
            return cipher;
        } catch (GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

}