/*
 *  Copyright 2011 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.io.*;
import java.util.*;
import java.util.Map.*;

/**
 * GCAX@\B
 */
final class Alias {

    private final Properties properties;
    private final File file;

    private long timestamp;

    Alias(File file) {
        this.properties = new Properties();
        this.file = file;
        this.timestamp = 0L;
    }

    /**
     * WJB
     * @param p p[^
     * @return WJ̕
     */
    String expand(Parameter p) {
        return expand(p.at(0), p);
    }

    /**
     * WJB
     * @param command R}h
     * @param p p[^
     * @return WJ̕
     */
    String expand(String command, Parameter p) {
        StringBuilder buffer = new StringBuilder(p.asString());
        String key = command;
        final int limit = 100;
        int limitCount = limit;
        while (containsKey(key)) {
            final String value = getValue(key);
            buffer.replace(0, key.length(), value);
            key = new Parameter(buffer.toString()).at(0);
            if (--limitCount < 0) {
                final String message = Resource.getString("e.alias-circulation-reference", limit);
                throw new CommandException(message);
            }
        }
        return buffer.toString();
    }

    /**
     * l̎擾B
     * @param key L[
     * @return l
     */
    String getValue(String key) {
        return properties.getProperty(key, "");
    }

    /**
     * l̐ݒB
     * @param key L[
     * @param value l
     */
    void setValue(String key, String value) {
        properties.setProperty(key, value);
    }

    /**
     * l̍폜B
     * @param key L[
     * @return 폜ꂽl
     */
    Object remove(String key) {
        return properties.remove(key);
    }

    /**
     * w肵L[ݒ肳Ă邩ǂ𒲂ׂB
     * @param key L[
     * @return 茋
     */
    boolean containsKey(String key) {
        return properties.containsKey(key);
    }

    /**
     * }bv󂩂ǂ𒲂ׂB
     * @return 茋
     */
    boolean isEmpty() {
        return properties.isEmpty();
    }

    /**
     * t@C烍[hB
     * @throws IOException
     */
    void load() throws IOException {
        InputStream is = new FileInputStream(file);
        try {
            properties.clear();
            properties.load(is);
        } finally {
            is.close();
        }
        timestamp = file.lastModified();
    }

    /**
     * XVĂ΃[hB
     * @throws IOException
     */
    void reload() throws IOException {
        if (updated()) {
            load();
        }
    }

    /**
     * t@CɕۑB
     * @throws IOException
     */
    void save() throws IOException {
        if (isEmpty()) {
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        OutputStream os = new FileOutputStream(file);
        try {
            properties.store(os, "");
        } finally {
            os.close();
        }
        timestamp = file.lastModified();
    }

    boolean updated() {
        return file.lastModified() > timestamp;
    }

    Set<Entry<Object, Object>> entrySet() {
        return properties.entrySet();
    }

}
