/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.CipherPassword;
import net.argius.stew.Command;
import net.argius.stew.Environment;
import net.argius.stew.LocalSystem;
import net.argius.stew.ui.Launcher;
import net.argius.stew.ui.OutputProcessor;
import net.argius.stew.ui.Prompt;
import net.argius.stew.ui.window.ConnectorEntry;
import net.argius.stew.ui.window.ConnectorMapEditDialog;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.FontControlLookAndFeel;
import net.argius.stew.ui.window.Menu;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.TextSearch;
import net.argius.stew.ui.window.TextSearchPanel;
import net.argius.stew.ui.window.WindowLaunchHelper1;
import net.argius.stew.ui.window.WindowLaunchHelper2;
import net.argius.stew.ui.window.WindowOutputProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowLauncher
implements Launcher {
    private static final Logger log = LoggerFactory.getLogger(WindowLauncher.class);
    private static final List<WindowLauncher> instances = Collections.synchronizedList(new ArrayList());
    private static final ImageIcon ICON = Resource.getImageIcon("stew.png");
    JComponent focused;
    private final WindowOutputProcessor op;
    private final Menu menu;
    private final JPanel panel1;
    private final JPanel panel2;
    private final JSplitPane split1;
    private final JSplitPane split2;
    private final ResultSetTable resultSetTable;
    private final ConsoleTextArea textArea;
    private final DatabaseInfoTree infoTree;
    private final TextSearchPanel textSearchPanel;
    private final JLabel statusBar;
    private final List<String> historyList;
    private final ExecutorService executorService;
    private Environment env;
    private Map<JComponent, TextSearch> textSearchMap;
    private int historyIndex;

    WindowLauncher() {
        instances.add(this);
        JSplitPane jSplitPane = new JSplitPane(1);
        DatabaseInfoTree databaseInfoTree = new DatabaseInfoTree();
        ResultSetTable resultSetTable = new ResultSetTable();
        ConsoleTextArea consoleTextArea = new ConsoleTextArea();
        this.op = new WindowOutputProcessor(resultSetTable, consoleTextArea);
        this.menu = new Menu();
        this.panel1 = new JPanel(new BorderLayout());
        this.panel2 = new JPanel(new BorderLayout());
        this.split1 = jSplitPane;
        this.split2 = new JSplitPane(0);
        this.resultSetTable = resultSetTable;
        this.textArea = consoleTextArea;
        this.infoTree = databaseInfoTree;
        this.textSearchPanel = new TextSearchPanel(this.op);
        this.statusBar = new JLabel(" ");
        this.historyList = new LinkedList<String>();
        this.historyIndex = 0;
        this.executorService = Executors.newScheduledThreadPool(3);
        this.op.setTitle(Resource.getString(".title", new Object[0]));
        this.op.setIconImage(ICON.getImage());
        this.op.setDefaultCloseOperation(0);
        jSplitPane.setResizeWeight(0.6f);
        jSplitPane.setDividerSize(4);
        this.split2.setOrientation(0);
        this.split2.setDividerSize(6);
        this.split2.setResizeWeight(0.6f);
        consoleTextArea.setMargin(new Insets(4, 8, 4, 4));
        consoleTextArea.setLineWrap(true);
        consoleTextArea.setWrapStyleWord(false);
        this.textSearchMap = new LinkedHashMap<JComponent, TextSearch>();
        final TextSearchPanel textSearchPanel = this.textSearchPanel;
        final Map<JComponent, TextSearch> map = this.textSearchMap;
        map.put(databaseInfoTree, WindowLaunchHelper2.createTextSearch(databaseInfoTree));
        map.put(resultSetTable, WindowLaunchHelper2.createTextSearch(resultSetTable));
        map.put(consoleTextArea, WindowLaunchHelper2.createTextSearch(consoleTextArea));
        for (Map.Entry<JComponent, TextSearch> entry : map.entrySet()) {
            final JComponent jComponent = entry.getKey();
            jComponent.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    WindowLauncher.this.focused = jComponent;
                    textSearchPanel.setCurrentTarget((TextSearch)map.get(jComponent));
                }
            });
            textSearchPanel.addTarget(entry.getValue());
        }
        this.statusBar.setForeground(Color.BLUE);
        this.panel2.add((Component)new JScrollPane(consoleTextArea, 22, 31), "Center");
        this.panel2.add((Component)textSearchPanel, "South");
        this.split2.setTopComponent(new JScrollPane(resultSetTable));
        this.split2.setBottomComponent(this.panel2);
        this.op.add((Component)this.panel1, "Center");
        this.op.add((Component)this.statusBar, "Last");
        this.op.setJMenuBar(this.menu);
        this.op.addPropertyChangeListener(this.menu);
        databaseInfoTree.addPropertyChangeListener(this.menu);
        resultSetTable.addPropertyChangeListener(this.menu);
        this.statusBar.addPropertyChangeListener(this.menu);
        this.loadConfiguration();
        this.op.removePropertyChangeListener(this.menu);
        databaseInfoTree.removePropertyChangeListener(this.menu);
        resultSetTable.removePropertyChangeListener(this.menu);
        this.op.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WindowLauncher.this.requestClose();
            }
        });
        WindowLaunchHelper1.bindEvents(databaseInfoTree, consoleTextArea);
        WindowLaunchHelper1.bindEvents(resultSetTable, this.op);
        WindowLaunchHelper1.bindEvents(consoleTextArea, this);
        this.menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowLauncher.this.performMenuEvent(Menu.Item.valueOf(actionEvent.getActionCommand()), (Component)actionEvent.getSource());
            }
        });
    }

    @Override
    public void launch(Environment environment) {
        this.env = environment;
        this.op.setEnvironment(environment);
        this.op.setVisible(true);
        this.op.output(new Prompt(environment));
        this.textArea.requestFocus();
    }

    void setInfoTreePane(boolean bl) {
        if (bl) {
            this.split1.removeAll();
            this.split1.setTopComponent(new JScrollPane(this.infoTree));
            this.split1.setBottomComponent(this.split2);
            this.panel1.removeAll();
            this.panel1.add((Component)this.split1, "Center");
            this.infoTree.setEnabled(true);
            if (this.env != null) {
                try {
                    this.infoTree.refreshRoot(this.env);
                }
                catch (SQLException sQLException) {
                    log.error("", sQLException);
                    this.op.showErrorDialog(sQLException);
                }
            }
        } else {
            this.infoTree.clear();
            this.infoTree.setEnabled(false);
            this.panel1.removeAll();
            this.panel1.add((Component)this.split2, "Center");
        }
        SwingUtilities.updateComponentTreeUI(this.op);
    }

    private void loadConfiguration() {
        Configuration configuration = Configuration.load(LocalSystem.getDirectory());
        this.op.setSize(configuration.getSize());
        this.op.setLocation(configuration.getLocation());
        this.split2.setDividerLocation(configuration.getDividerLocation());
        this.statusBar.setVisible(configuration.isShowStatusBar());
        this.resultSetTable.setShowColumnNumber(configuration.isShowTableColumnNumber());
        this.split1.setDividerLocation(configuration.getDividerLocation0());
        this.op.setAlwaysOnTop(configuration.isAlwaysOnTop());
        this.op.setAutoAdjustMode(Menu.Item.valueOf(configuration.getAutoAdjustMode()));
        this.setInfoTreePane(configuration.isShowInfoTree());
        this.changeFont("monospaced", 0, 1.0);
    }

    private void saveConfiguration() {
        Configuration configuration = Configuration.load(LocalSystem.getDirectory());
        if ((this.op.getExtendedState() & 6) == 0) {
            configuration.setSize(this.op.getSize());
            configuration.setLocation(this.op.getLocation());
            configuration.setDividerLocation(this.split2.getDividerLocation());
            configuration.setDividerLocation0(this.split1.getDividerLocation());
        }
        configuration.setShowStatusBar(this.statusBar.isVisible());
        configuration.setShowTableColumnNumber(this.resultSetTable.isShowColumnNumber());
        configuration.setShowInfoTree(this.infoTree.isEnabled());
        configuration.setAlwaysOnTop(this.op.isAlwaysOnTop());
        configuration.setAutoAdjustMode(this.op.getAutoAdjustMode().name());
        configuration.save();
    }

    private void changeFont(String string, int n, double d) {
        FontControlLookAndFeel.change(string, n, d);
        SwingUtilities.updateComponentTreeUI(this.op);
        Font font = this.textArea.getFont();
        if (font != null) {
            this.statusBar.setFont(font.deriveFont((float)font.getSize() * 0.8f));
        }
    }

    void handleError(Throwable throwable) {
        log.error("", throwable);
        this.op.showErrorDialog(throwable);
    }

    void performMenuEvent(Menu.Item item, Component component) {
        try {
            this.resultSetTable.editingCanceled(new ChangeEvent(component));
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
        switch (item) {
            case NEW: {
                WindowLauncher.invoke();
                break;
            }
            case CLOSE: {
                this.requestClose();
                break;
            }
            case QUIT: {
                this.requestExit();
                break;
            }
            case CUT: 
            case COPY: 
            case PASTE: 
            case SELECT_ALL: {
                KeyStroke keyStroke = ((JMenuItem)component).getAccelerator();
                ActionListener actionListener = this.focused.getActionForKeyStroke(keyStroke);
                if (actionListener == null) break;
                actionListener.actionPerformed(new ActionEvent(this.focused, 1001, ""));
                break;
            }
            case FIND: {
                this.textSearchPanel.setCurrentTarget(this.textSearchMap.get(this.focused));
                this.textSearchPanel.setVisible(true);
                break;
            }
            case TOGGLE_FOCUS: {
                if (this.textArea.isFocusOwner()) {
                    this.resultSetTable.requestFocus();
                    break;
                }
                this.textArea.requestFocus();
                break;
            }
            case CLEAR_MESSAGE: {
                this.textArea.clear();
                this.executeCommand("");
                break;
            }
            case STATUS_BAR: {
                this.statusBar.setVisible(((JCheckBoxMenuItem)component).isSelected());
                break;
            }
            case COLUMN_NUMBER: {
                this.resultSetTable.setShowColumnNumber(((JCheckBoxMenuItem)component).isSelected());
                this.split2.getTopComponent().repaint();
                break;
            }
            case INFO_TREE: {
                this.setInfoTreePane(((JCheckBoxMenuItem)component).isSelected());
                this.op.validate();
                this.op.repaint();
                break;
            }
            case ALWAYS_ON_TOP: {
                this.op.setAlwaysOnTop(((JCheckBoxMenuItem)component).isSelected());
                break;
            }
            case WIDEN_COLUMN_WIDTH: {
                this.op.changeTableColumnWidth(1.5);
                break;
            }
            case NARROW_COLUMN_WIDTH: {
                this.op.changeTableColumnWidth(0.6666666865348816);
                break;
            }
            case ADJUST_COLUMN_WIDTH: {
                this.op.adjustTableColumnWidth();
                break;
            }
            case AUTO_ADJUST_MODE_NONE: 
            case AUTO_ADJUST_MODE_HEADER: 
            case AUTO_ADJUST_MODE_VALUE: 
            case AUTO_ADJUST_MODE_HEADERANDVALUE: {
                this.op.setAutoAdjustMode(item);
                break;
            }
            case REFRESH: {
                String string;
                ResultSetTableModel resultSetTableModel;
                if (!(this.resultSetTable.getModel() instanceof ResultSetTableModel) || !(resultSetTableModel = this.resultSetTable.getResultSetTableModel()).isSameConnection(this.env.getCurrentConnection()) || (string = resultSetTableModel.getCommandString()) == null || string.length() <= 0) break;
                this.executeCommand(string);
                break;
            }
            case EXECUTE: {
                this.executeCommand(this.textArea.getEditableText());
                break;
            }
            case BREAK: {
                this.env.getOutputProcessor().close();
                this.env.setOutputProcessor(new WindowOutputProcessor.Bypass(this.op));
                this.op.output(Resource.getString("i.cancelled", new Object[0]));
                this.doPostProcess();
                break;
            }
            case HISTORY_BACK: {
                this.retrieveHistory(-1);
                break;
            }
            case HISTORY_NEXT: {
                this.retrieveHistory(1);
                break;
            }
            case ROLLBACK: {
                if (!this.confirmCommitable() || JOptionPane.showConfirmDialog(this.op, Resource.getString("i.confirm-rollback", new Object[0]), null, 2) != 0) break;
                this.executeCommand("rollback");
                break;
            }
            case COMMIT: {
                if (!this.confirmCommitable() || JOptionPane.showConfirmDialog(this.op, Resource.getString("i.confirm-commit", new Object[0]), null, 2) != 0) break;
                this.executeCommand("commit");
                break;
            }
            case CONNECT: {
                this.env.updateConnectorMap();
                if (this.env.getConnectorMap().isEmpty()) {
                    JOptionPane.showMessageDialog(this.op, Resource.getString("w.no-connector", new Object[0]));
                    return;
                }
                Object[] objectArray = ConnectorEntry.toList(this.env.getConnectorMap().values()).toArray();
                String string = Resource.getString("i.choose-connection", new Object[0]);
                Object object = JOptionPane.showInputDialog(this.op, string, null, -1, null, objectArray, objectArray[0]);
                if (object == null) break;
                ConnectorEntry connectorEntry = (ConnectorEntry)object;
                this.executeCommand("connect " + connectorEntry.getId());
                break;
            }
            case DISCONNECT: {
                this.executeCommand("disconnect");
                break;
            }
            case ENCRYPTION_KEY: {
                JPasswordField jPasswordField = new JPasswordField(20);
                Object[] objectArray = new Object[]{Resource.getString("i.input-encryption-key", new Object[0]), jPasswordField};
                if (JOptionPane.showConfirmDialog(this.op, objectArray, null, 2) != 0) break;
                CipherPassword.setSecretKey(String.valueOf(jPasswordField.getPassword()));
                break;
            }
            case EDIT_CONNECTORS: {
                this.env.updateConnectorMap();
                if (this.env.getCurrentConnector() != null) {
                    JOptionPane.showMessageDialog(this.op, Resource.getString("i.reconnect-after-edited-current-connector", new Object[0]));
                }
                ConnectorMapEditDialog connectorMapEditDialog = new ConnectorMapEditDialog(this.op, this.env);
                connectorMapEditDialog.pack();
                connectorMapEditDialog.setModal(true);
                connectorMapEditDialog.setLocationRelativeTo(this.op);
                connectorMapEditDialog.setVisible(true);
                this.env.updateConnectorMap();
                break;
            }
            case SORT: {
                this.op.sortTable(this.resultSetTable.getSelectedColumn());
                break;
            }
            case EXPORT: {
                try {
                    this.op.exportTableContent();
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            case HELP: {
                JOptionPane.showMessageDialog(this.op, Resource.getString("i.help-see-release-package", new Object[0]), null, -1);
                break;
            }
            case ABOUT: {
                ImageIcon imageIcon = new ImageIcon();
                if (this.op.getIconImage() != null) {
                    imageIcon.setImage(this.op.getIconImage());
                }
                JOptionPane.showMessageDialog(this.op, Resource.getString(".about", Resource.getVersion()), null, -1, imageIcon);
                break;
            }
            default: {
                log.warn(String.format("ignored [%s] (%s)", new Object[]{item, component}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invoke() {
        block6: {
            WindowLauncher windowLauncher = new WindowLauncher();
            Environment environment = new Environment();
            environment.setOutputProcessor(new WindowOutputProcessor.Bypass(windowLauncher.op));
            windowLauncher.launch(environment);
            try {
                File file = new File(LocalSystem.getDirectory(), "keybind.conf");
                if (!file.exists()) break block6;
                ArrayList<String> arrayList = new ArrayList<String>();
                Scanner scanner = new Scanner(file);
                try {
                    while (scanner.hasNextLine()) {
                        arrayList.add(scanner.nextLine());
                    }
                }
                finally {
                    scanner.close();
                }
                WindowLauncher.changeKeyBinds(arrayList);
            }
            catch (Exception exception) {
                windowLauncher.handleError(exception);
            }
        }
    }

    static void changeKeyBinds(List<String> list) {
        Pattern pattern = Pattern.compile("\\s*([^=\\s]+)\\s*=(.*)");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.matches("\\s*#.*")) continue;
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                try {
                    Menu.Item item = Menu.Item.valueOf(matcher.group(1));
                    KeyStroke keyStroke = KeyStroke.getKeyStroke(matcher.group(2));
                    for (WindowLauncher windowLauncher : instances) {
                        windowLauncher.menu.setAccelerator(item, keyStroke);
                    }
                    continue;
                }
                catch (Exception exception) {
                    arrayList.add(string);
                    continue;
                }
            }
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            throw new IllegalArgumentException(((Object)arrayList).toString());
        }
    }

    static void exit() {
        for (WindowLauncher windowLauncher : new ArrayList<WindowLauncher>(instances)) {
            try {
                windowLauncher.close();
            }
            catch (Exception exception) {
                log.warn("error occurred when closing all instances", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        instances.remove(this);
        try {
            this.env.release();
            this.saveConfiguration();
            this.executorService.shutdown();
        }
        finally {
            this.op.dispose();
        }
    }

    private boolean confirmYes(String string) {
        return JOptionPane.showConfirmDialog(this.op, string, "", 0) == 0;
    }

    private boolean confirmCommitable() {
        if (this.env.getCurrentConnection() == null) {
            JOptionPane.showMessageDialog(this.op, Resource.getString("w.not-connect", new Object[0]), null, 0);
            return false;
        }
        if (this.env.getCurrentConnector().isReadOnly()) {
            JOptionPane.showMessageDialog(this.op, Resource.getString("w.connector-readonly", new Object[0]), null, 0);
            return false;
        }
        return true;
    }

    private void retrieveHistory(int n) {
        if (this.historyList.isEmpty()) {
            return;
        }
        this.historyIndex += n;
        if (this.historyIndex >= this.historyList.size()) {
            this.historyIndex = 0;
        } else if (this.historyIndex < 0) {
            this.historyIndex = this.historyList.size() - 1;
        }
        this.textArea.replace(this.historyList.get(this.historyIndex));
        int n2 = this.textArea.getEndPosition();
        this.textArea.setSelectionStart(n2);
        this.textArea.moveCaretPosition(n2);
        this.textArea.requestFocus();
    }

    void requestClose() {
        if (instances.size() == 1) {
            this.requestExit();
        } else if (this.env.getCurrentConnection() == null || this.confirmYes(Resource.getString("i.confirm-close", new Object[0]))) {
            this.close();
        }
    }

    private void requestExit() {
        if (this.confirmYes(Resource.getString("i.confirm-quit", new Object[0]))) {
            WindowLauncher.exit();
        }
    }

    void executeCommand(String string) {
        assert (string != null);
        if (!string.equals(this.textArea.getEditableText())) {
            this.textArea.replace(string);
        }
        this.op.output("");
        if (string.trim().length() == 0) {
            this.doPostProcess();
        } else {
            final String string2 = string;
            final Environment environment = this.env;
            final DatabaseInfoTree databaseInfoTree = this.infoTree;
            final JLabel jLabel = this.statusBar;
            final OutputProcessor outputProcessor = environment.getOutputProcessor();
            try {
                this.doPreProcess();
                this.executorService.execute(new Runnable(){

                    public void run() {
                        Connection connection = environment.getCurrentConnection();
                        long l = System.currentTimeMillis();
                        if (!Command.invoke(environment, string2)) {
                            WindowLauncher.exit();
                        }
                        if (databaseInfoTree.isEnabled()) {
                            try {
                                if (environment.getCurrentConnection() != connection) {
                                    databaseInfoTree.clear();
                                    if (environment.getCurrentConnection() != null) {
                                        databaseInfoTree.refreshRoot(environment);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                WindowLauncher.this.handleError(throwable);
                            }
                        }
                        if (environment.getOutputProcessor() == outputProcessor) {
                            l = System.currentTimeMillis() - l;
                            jLabel.setText(Resource.getString("i.statusbar-message", Float.valueOf((float)l / 1000.0f), string2));
                            WindowLauncher.this.doPostProcess();
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                this.historyIndex = this.historyList.size();
            }
            if (this.historyList.contains(string)) {
                this.historyList.remove(string);
            }
            this.historyList.add(string);
        }
        this.historyIndex = this.historyList.size();
    }

    void doPreProcess() {
        ((Menu)this.op.getJMenuBar()).setEnabledStates(true);
        this.resultSetTable.setEnabled(false);
        this.textArea.setEnabled(false);
        this.op.repaint();
    }

    void doPostProcess() {
        ((Menu)this.op.getJMenuBar()).setEnabledStates(false);
        this.resultSetTable.setEnabled(true);
        this.textArea.setEnabled(true);
        this.op.output(new Prompt(this.env));
        this.textArea.requestFocus();
    }

    static void wakeup() {
        for (WindowLauncher windowLauncher : new ArrayList<WindowLauncher>(instances)) {
            try {
                SwingUtilities.updateComponentTreeUI(windowLauncher.op);
            }
            catch (Exception exception) {
                log.warn("", exception);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("wake up");
        }
    }

    public static void main(String ... stringArray) {
        int n = LocalSystem.getPropertyAsInt("net.argius.stew.ui.window.resident");
        if (n > 0) {
            long l = (long)n * 60000L;
            Timer timer = new Timer(true);
            timer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            WindowLauncher.wakeup();
                        }
                    });
                }
            }, l, l);
        }
        final Logger logger = log;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread thread, Throwable throwable) {
                        logger.fatal(thread, throwable);
                    }
                });
                WindowLauncher.invoke();
            }
        });
    }

    public static final class Configuration {
        private static final Logger log = LoggerFactory.getLogger(Configuration.class);
        private transient File directory;
        private Dimension size = new Dimension(640, 480);
        private Point location = new Point(200, 200);
        private int dividerLocation = -1;
        private int dividerLocation0 = -1;
        private boolean showStatusBar = false;
        private boolean showTableColumnNumber = false;
        private boolean showInfoTree = false;
        private boolean alwaysOnTop = false;
        private String autoAdjustMode = Menu.Item.AUTO_ADJUST_MODE_NONE.name();

        void setDirectory(File file) {
            this.directory = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save() {
            File file = Configuration.getFile(this.directory);
            if (log.isDebugEnabled()) {
                log.debug(String.format("save Configuration to: [%s]", file));
            }
            try {
                XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(file));
                try {
                    xMLEncoder.writeObject(this);
                }
                finally {
                    xMLEncoder.close();
                }
            }
            catch (Exception exception) {
                log.warn("", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Configuration load(File file) {
            File file2 = Configuration.getFile(file);
            if (log.isDebugEnabled()) {
                log.debug(String.format("load Configuration from: [%s]", file2));
            }
            if (file2.exists()) {
                XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(file2));
                try {
                    Configuration configuration = (Configuration)xMLDecoder.readObject();
                    configuration.setDirectory(file);
                    Configuration configuration2 = configuration;
                    xMLDecoder.close();
                    return configuration2;
                }
                catch (Throwable throwable) {
                    try {
                        xMLDecoder.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        log.warn("", exception);
                    }
                }
            }
            Configuration configuration = new Configuration();
            configuration.setDirectory(file);
            return configuration;
        }

        private static File getFile(File file) {
            File file2 = new File(file, Configuration.class.getName() + ".xml");
            return file2.getAbsoluteFile();
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension dimension) {
            this.size = dimension;
        }

        public Point getLocation() {
            return this.location;
        }

        public void setLocation(Point point) {
            this.location = point;
        }

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int n) {
            this.dividerLocation = n;
        }

        public int getDividerLocation0() {
            return this.dividerLocation0;
        }

        public void setDividerLocation0(int n) {
            this.dividerLocation0 = n;
        }

        public boolean isShowStatusBar() {
            return this.showStatusBar;
        }

        public void setShowStatusBar(boolean bl) {
            this.showStatusBar = bl;
        }

        public boolean isShowTableColumnNumber() {
            return this.showTableColumnNumber;
        }

        public void setShowTableColumnNumber(boolean bl) {
            this.showTableColumnNumber = bl;
        }

        public boolean isShowInfoTree() {
            return this.showInfoTree;
        }

        public void setShowInfoTree(boolean bl) {
            this.showInfoTree = bl;
        }

        public boolean isAlwaysOnTop() {
            return this.alwaysOnTop;
        }

        public void setAlwaysOnTop(boolean bl) {
            this.alwaysOnTop = bl;
        }

        public String getAutoAdjustMode() {
            return this.autoAdjustMode;
        }

        public void setAutoAdjustMode(String string) {
            this.autoAdjustMode = string;
        }
    }
}

