/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.argius.stew.io.Importer;
import net.argius.stew.io.StringBasedSerializer;

public final class XmlImporter
extends Importer {
    private static final Pattern PATTERN_TAG = Pattern.compile("<(/?)([A-Za-z0-9]+)([^/>]+)?(/?) *>");
    private static final Pattern PATTERN_TAG_HEADER_ATTRIBUTE = Pattern.compile("(?i)index=\"[^0-9\"]*([0-9]+)[^0-9\"]*\"");
    private static final String SLASH = "/";
    private static final String TAG_TABLE = "table";
    private static final String TAG_HEADERROW = "headerrow";
    private static final String TAG_HEADER = "header";
    private static final String TAG_ROW = "row";
    private static final String TAG_NULL = "null";
    private BufferedReader reader;
    private StringBuilder buffer;
    private char[] chars;
    private boolean hasMoreData;

    public XmlImporter(InputStream inputStream) throws IOException {
        super(inputStream);
        String string = this.getEncoding();
        this.reader = new BufferedReader(new InputStreamReader(inputStream, string));
        this.buffer = new StringBuilder(1024);
        this.chars = new char[1024];
        this.hasMoreData = this.seekStartTag(TAG_TABLE);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object[] readHeader() throws IOException {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        boolean bl = false;
        block0: while (true) {
            int n;
            block11: {
                Object[] objectArray;
                block9: {
                    block10: {
                        Matcher matcher;
                        if (!(matcher = PATTERN_TAG.matcher(this.buffer)).find()) break block10;
                        objectArray = matcher.group(1);
                        String string = matcher.group(2);
                        String string2 = String.valueOf(matcher.group(3));
                        String string3 = matcher.group(4);
                        this.buffer.delete(0, matcher.end());
                        if (string.equalsIgnoreCase(TAG_HEADERROW)) {
                            if (objectArray.equals(SLASH) || string3.equals(SLASH)) {
                                bl = false;
                                break block9;
                            } else {
                                bl = true;
                                continue;
                            }
                        }
                        if (string.equalsIgnoreCase(TAG_TABLE) || string.equalsIgnoreCase(TAG_ROW)) break block9;
                        if (!bl || !string.equalsIgnoreCase(TAG_HEADER)) continue;
                        Matcher matcher2 = PATTERN_TAG_HEADER_ATTRIBUTE.matcher(string2);
                        n = matcher2.find() ? Integer.parseInt(matcher2.group(1)) : hashMap.size();
                        break block11;
                    }
                    if (this.readChars() > 0) continue;
                }
                if (hashMap.isEmpty()) {
                    return new Object[0];
                }
                int n2 = (Integer)Collections.max(hashMap.keySet());
                objectArray = new Object[n2 + 1];
                int n3 = 0;
                while (true) {
                    if (n3 > n2) {
                        return objectArray;
                    }
                    if (hashMap.containsKey(n3)) {
                        objectArray[n3] = hashMap.get(n3);
                    }
                    ++n3;
                }
            }
            do {
                Matcher matcher;
                if (!(matcher = PATTERN_TAG.matcher(this.buffer)).find() || !matcher.group(1).equals(SLASH)) continue;
                int n4 = matcher.start();
                CharSequence charSequence = this.buffer.subSequence(0, n4);
                hashMap.put(n, XmlImporter.parseCData(charSequence));
                this.buffer.delete(0, matcher.end());
                continue block0;
            } while (this.readChars() > 0);
        }
    }

    public Object[] nextRow() throws IOException {
        this.ensureOpen();
        while (this.hasMoreData) {
            Matcher matcher = PATTERN_TAG.matcher(this.buffer);
            if (matcher.find()) {
                String string = matcher.group(2);
                String string2 = matcher.group(4);
                this.buffer.delete(0, matcher.end());
                if (string.equalsIgnoreCase(TAG_ROW)) {
                    if (string2.equals(SLASH)) {
                        return new Object[0];
                    }
                    return this.parseRow();
                }
                if (!string.equalsIgnoreCase(TAG_TABLE)) continue;
                this.hasMoreData = false;
                continue;
            }
            if (this.readChars() > 0) continue;
            this.hasMoreData = false;
            break;
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        finally {
            this.reader = null;
            this.buffer = null;
            super.close();
        }
    }

    private String getEncoding() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.is.read()) >= 0) {
            byteArrayOutputStream.write(n);
            if (n != 62) continue;
            break;
        }
        return XmlImporter.parseEncoding(byteArrayOutputStream.toString("ISO8859-1"));
    }

    private static String parseEncoding(String string) {
        Pattern pattern = Pattern.compile("<\\?xml.+encoding=\"([^\"]+)\"\\?>", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "utf-8";
    }

    private boolean seekStartTag(String string) throws IOException {
        do {
            String string2;
            Matcher matcher;
            if (!(matcher = PATTERN_TAG.matcher(this.buffer)).find() || (string2 = matcher.group(1)).equals(SLASH) || !string.equalsIgnoreCase(matcher.group(2))) continue;
            int n = matcher.group(4).equals(SLASH) ? matcher.start() : matcher.end();
            this.buffer.delete(0, n);
            return true;
        } while (this.readChars() > 0);
        return false;
    }

    private Object[] parseRow() throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block0: while (this.hasMoreData) {
            Matcher matcher = PATTERN_TAG.matcher(this.buffer);
            if (matcher.find()) {
                String string = matcher.group(1);
                String string2 = matcher.group(2);
                String string3 = matcher.group(4);
                this.buffer.delete(0, matcher.end());
                if (string.equals(SLASH)) {
                    if (string2.equals(TAG_ROW)) {
                        return arrayList.toArray();
                    }
                    if (!string2.equals(TAG_TABLE)) continue;
                    break;
                }
                if (string2.equalsIgnoreCase(TAG_NULL)) {
                    arrayList.add(null);
                    continue;
                }
                if (string3.equals(SLASH)) {
                    arrayList.add(XmlImporter.deserialize(string2, ""));
                    continue;
                }
                do {
                    Matcher matcher2;
                    if (!(matcher2 = PATTERN_TAG.matcher(this.buffer)).find() || !matcher2.group(1).equals(SLASH)) continue;
                    int n = matcher2.start();
                    arrayList.add(XmlImporter.deserialize(string2, ((Object)this.buffer.subSequence(0, n)).toString()));
                    this.buffer.delete(0, matcher2.end());
                    continue block0;
                } while (this.readChars() > 0);
                continue;
            }
            if (this.readChars() > 0) continue;
            break;
        }
        throw new IOException("</row> not found");
    }

    private static Object deserialize(String string, String string2) throws IOException {
        return XmlImporter.parseCData(StringBasedSerializer.deserialize(string, string2));
    }

    private static Object parseCData(Object object) {
        String string;
        if (object instanceof String && (string = (String)object).matches("^<!\\[CDATA\\[.*\\]\\]>$")) {
            String string2 = string.substring(9, string.length() - 3);
            if (string2.contains("]]&gt;")) {
                string2 = string2.replaceAll("\\]\\]&gt;", "]]>");
            }
            return string2;
        }
        return object;
    }

    private int readChars() throws IOException {
        int n = this.reader.read(this.chars);
        if (n > 0) {
            this.buffer.append(this.chars, 0, n);
        }
        return n;
    }
}

