/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.sql.*;
import java.util.*;

import net.argius.logging.*;

/**
 * RlN^B
 * JDBCRlNV̐ڑB
 */
public final class Connector {

    private static final Logger log = LoggerFactory.getLogger(Connector.class);

    private final String id;
    private final Properties props;
    private final Password password;

    private transient Driver driver;

    /**
     * RXgN^B
     * @param id ID
     * @param props vpeB
     */
    public Connector(String id, Properties props) {
        assert id != null;
        if (!id.matches("[A-Za-z0-9]+")) {
            throw new IllegalArgumentException("illegal id : " + id);
        }
        Properties p = new Properties();
        p.putAll(props);
        Password password = createPasswordInstance(props.getProperty("password.class"));
        password.setTransformedString(props.getProperty("password"));
        this.id = id;
        this.props = p;
        this.password = password;
    }

    /**
     * PasswordCX^X̐B
     * @param className NX
     * @return CX^X
     */
    private static Password createPasswordInstance(String className) {
        if (className != null) {
            try {
                return (Password)DynamicLoader.newInstance(className);
            } catch (Exception ex) {
                log.warn("", ex);
            }
        }
        return new PlainTextPassword();
    }

    /**
     * Connector̐(Rs[RXgN^)B
     * @param id ID
     * @param src Rs[̃CX^X
     */
    public Connector(String id, Connector src) {
        this(id, new Properties(src.props));
    }

    /**
     * ID̎擾B
     * @return ID
     */
    public String getId() {
        return id;
    }

    /**
     * ̂̎擾B
     * @return 
     */
    public String getName() {
        return props.getProperty("name");
    }

    /**
     * classpath̎擾B
     * @return classpath
     */
    public String getClasspath() {
        return props.getProperty("classpath", "");
    }

    /**
     * driver̎擾B
     * @return driver
     */
    public String getDriver() {
        final String driver = props.getProperty("driver");
        if (log.isDebugEnabled()) {
            log.debug(String.format("driver=[%s]", driver));
        }
        return driver;
    }

    /**
     * url̎擾B
     * @return url
     */
    public String getUrl() {
        return props.getProperty("url");
    }

    /**
     * user̎擾B
     * @return user
     */
    public String getUser() {
        return props.getProperty("user");
    }

    /**
     * pX[hIuWFNg̎擾B
     * @return pX[hIuWFNg
     */
    public Password getPassword() {
        return password;
    }

    /**
     * readonly̎擾B
     * @return readonly Ȃ <code>true</code>
     */
    public boolean isReadOnly() {
        String s = props.getProperty("readonly");
        return Boolean.valueOf(s).booleanValue();
    }

    /**
     * rollback̎擾B
     * @return [obN@\gpȂ <code>true</code>
     */
    public boolean usesAutoRollback() {
        String s = props.getProperty("rollback");
        return Boolean.valueOf(s).booleanValue();
    }

    /**
     * ConnectorProperties֕ϊB
     * @return Properties
     */
    public Properties toProperties() {
        return (Properties)props.clone();
    }

    /**
     * RlNV̎擾B
     * @return RlNV
     * @throws SQLException
     */
    public Connection getConnection() throws SQLException {
        if (driver == null) {
            driver = ConnectorDriverManager.getDriver(getUrl(), getDriver(), getClasspath());
            if (driver == null) {
                throw new SQLException("failed to load driver");
            }
            if (log.isDebugEnabled()) {
                log.debug(driver);
            }
        }
        Properties p = new Properties();
        p.setProperty("user", getUser());
        p.setProperty("password", getPassword().getRowString());
        if (!driver.acceptsURL(getUrl())) {
            throw new SQLException("invalid url: " + getUrl());
        }
        if (log.isInfoEnabled()) {
            log.info("driver.connect start");
        }
        Connection conn = driver.connect(getUrl(), p);
        if (log.isInfoEnabled()) {
            log.info("driver.connect end");
        }
        if (conn == null) {
            throw new IllegalStateException("driver returned null");
        }
        return conn;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((props == null) ? 0 : props.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)obj;
        return props.equals(other.props);
    }

    @Override
    public String toString() {
        return "Connector:" + id;
    }

}