/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;
import net.argius.stew.Iteration;
import net.argius.stew.io.CsvFormatter;
import net.argius.stew.io.Importer;
import net.argius.stew.io.SmartImporter;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.WindowLaunchHelper3;
import net.argius.stew.ui.window.WindowLauncher;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class WindowLaunchHelper1 {
    private static final String COPY = "copy";
    private static final String SELECT_ALL = "selectAll";
    private static final String DELETE_ROWS = "deleteRows";
    private static final String LINK_ROWS_TO_DATABASE = "linkRowsToDatabase";
    private static final String DUPLICATE_ROWS = "duplicateRows";
    private static final String INSERT_FROM_CLIPBOARD = "insertFromClipboard";
    private static final String ADD_EMPTY_ROW = "addEmptyRow";
    private static final String PASTE = "paste";
    private static final String CLEAR_CELLS = "clearCells";
    private static final String COPY_COLUMN_NAMES = "copyColumnNames";
    private static final String COPY_WITH_ESCAPE = "copyWithEscape";
    private static final String GENERATE_INSERT_STATEMENT = "generate-insert-statement";
    private static final String GENERATE_UPDATE_STATEMENT = "generate-update-statement";
    private static final String GENERATE_SELECT_PHRASE = "generate-select-phrase";
    private static final String GENERATE_WHERE_PHRASE = "generate-where-phrase";
    private static final String REFRESH = "refresh";
    private static final String COPY_FULL_NAME = "copy-full-name";

    private WindowLaunchHelper1() {
    }

    static void bindEvents(DatabaseInfoTree databaseInfoTree, final ConsoleTextArea consoleTextArea) {
        ActionUtility actionUtility = ActionUtility.getInstance(databaseInfoTree);
        databaseInfoTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                consoleTextArea.replaceSelection(actionEvent.getActionCommand());
                consoleTextArea.requestFocus();
            }
        });
        actionUtility.setContextMenu(new String[]{COPY_FULL_NAME, REFRESH, GENERATE_WHERE_PHRASE, GENERATE_SELECT_PHRASE, GENERATE_UPDATE_STATEMENT, GENERATE_INSERT_STATEMENT}, "FRWSUI".toCharArray());
    }

    static void bindEvents(final ResultSetTable resultSetTable, final WindowOutputProcessor windowOutputProcessor) {
        ActionUtility actionUtility = ActionUtility.getInstance(resultSetTable);
        int n = Resource.getMenuShortcutKeyMask();
        final AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                resultSetTable.editingCanceled(new ChangeEvent(actionEvent.getSource()));
            }
        };
        actionUtility.bindAction((Action)new AbstractAction(COPY_WITH_ESCAPE){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int n : resultSetTable.getSelectedRows()) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (int n2 : resultSetTable.getSelectedColumns()) {
                        Object object = resultSetTable.getValueAt(n, n2);
                        arrayList2.add(CsvFormatter.AUTO.format(object == null ? "" : String.valueOf(object)));
                    }
                    arrayList.add(Iteration.join(arrayList2, "\t"));
                }
                WindowLaunchHelper3.setClipboard(Iteration.join(arrayList, "\n"));
            }
        }, KeyStroke.getKeyStroke(67, n | 0x200));
        actionUtility.bindAction((Action)new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(WindowLaunchHelper3.getClipboard().getBytes());
                    SmartImporter smartImporter = new SmartImporter(byteArrayInputStream, "\t");
                    try {
                        int[] nArray = resultSetTable.getSelectedColumns();
                        for (int n : resultSetTable.getSelectedRows()) {
                            Object[] objectArray = ((Importer)smartImporter).nextRow();
                            int n2 = Math.min(nArray.length, objectArray.length);
                            for (int i = 0; i < n2; ++i) {
                                resultSetTable.setValueAt(objectArray[i], n, nArray[i]);
                            }
                        }
                    }
                    finally {
                        ((Importer)smartImporter).close();
                    }
                    resultSetTable.repaint();
                }
                catch (Exception exception) {
                    WindowLaunchHelper3.handleError(exception, windowOutputProcessor);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, PASTE);
        actionUtility.bindAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                int n = resultSetTableModel.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(resultSetTableModel.getColumnName(i));
                }
                WindowLaunchHelper3.setClipboard(Iteration.join(arrayList, "\t"));
            }
        }, COPY_COLUMN_NAMES);
        actionUtility.bindAction((Action)new AbstractAction(CLEAR_CELLS){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int[] nArray = resultSetTable.getSelectedColumns();
                    for (int n : resultSetTable.getSelectedRows()) {
                        int n2 = nArray.length;
                        for (int i = 0; i < n2; ++i) {
                            resultSetTable.setValueAt(null, n, nArray[i]);
                        }
                    }
                    resultSetTable.repaint();
                }
                catch (Exception exception) {
                    WindowLaunchHelper3.handleError(exception, windowOutputProcessor);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, KeyStroke.getKeyStroke(127, 0));
        actionUtility.bindAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                int n = resultSetTable.getSelectedRow();
                if (n >= 0) {
                    resultSetTableModel.insertUnlinkedRow(n + 1, new Object[resultSetTableModel.getColumnCount()]);
                } else {
                    resultSetTableModel.addUnlinkedRow(new Object[resultSetTableModel.getColumnCount()]);
                }
            }
        }, ADD_EMPTY_ROW);
        actionUtility.bindAction((Action)new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SmartImporter smartImporter = new SmartImporter(WindowLaunchHelper3.getClipboardAsReader(), "\t");
                    try {
                        Object[] objectArray;
                        ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                        while ((objectArray = ((Importer)smartImporter).nextRow()).length != 0) {
                            resultSetTableModel.addUnlinkedRow(objectArray);
                            resultSetTableModel.linkRow(resultSetTableModel.getRowCount() - 1);
                        }
                        resultSetTable.repaintRowHeader("model");
                    }
                    finally {
                        ((Importer)smartImporter).close();
                    }
                }
                catch (Exception exception) {
                    WindowLaunchHelper3.handleError(exception, windowOutputProcessor);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, INSERT_FROM_CLIPBOARD);
        actionUtility.bindAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                Vector<Vector> vector = resultSetTableModel.getDataVector();
                int[] nArray = resultSetTable.getSelectedRows();
                int n = nArray[nArray.length - 1];
                for (int n2 : nArray) {
                    resultSetTableModel.insertUnlinkedRow(++n, (Vector)((Vector)vector.get(n2)).clone());
                }
                resultSetTable.repaint();
                resultSetTable.repaintRowHeader("model");
            }
        }, DUPLICATE_ROWS);
        actionUtility.bindAction((Action)new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                try {
                    for (int n : resultSetTable.getSelectedRows()) {
                        resultSetTableModel.linkRow(n);
                    }
                }
                catch (SQLException sQLException) {
                    WindowLaunchHelper3.handleError(sQLException, windowOutputProcessor);
                }
                finally {
                    resultSetTable.repaintRowHeader("unlinkedRowStatus");
                }
            }
        }, LINK_ROWS_TO_DATABASE);
        actionUtility.bindAction((Action)new AbstractAction(DELETE_ROWS){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n;
                    ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                    while ((n = resultSetTable.getSelectedRow()) >= 0) {
                        if (resultSetTableModel.isLinkedRow(n)) {
                            boolean bl = resultSetTableModel.removeLinkedRow(n);
                            assert (bl);
                            continue;
                        }
                        resultSetTableModel.removeRow(n);
                    }
                }
                catch (SQLException sQLException) {
                    WindowLaunchHelper3.handleError(sQLException, windowOutputProcessor);
                }
                finally {
                    resultSetTable.repaintRowHeader("model");
                }
            }
        }, KeyStroke.getKeyStroke(45, n | 0x40));
        actionUtility.bindAction((Action)new AbstractAction("sort"){

            public void actionPerformed(ActionEvent actionEvent) {
                windowOutputProcessor.sortTable(resultSetTable.getSelectedColumn());
            }
        }, KeyStroke.getKeyStroke(83, 512));
        actionUtility.bindAction((Action)new AbstractAction("adjustColumnWidth"){

            public void actionPerformed(ActionEvent actionEvent) {
                windowOutputProcessor.adjustTableColumnWidth();
            }
        }, KeyStroke.getKeyStroke(47, n));
        String[] stringArray = new String[]{COPY, COPY_WITH_ESCAPE, PASTE, COPY_COLUMN_NAMES, CLEAR_CELLS, SELECT_ALL, "", ADD_EMPTY_ROW, INSERT_FROM_CLIPBOARD, DUPLICATE_ROWS, LINK_ROWS_TO_DATABASE, DELETE_ROWS};
        final List<String> list = Arrays.asList(PASTE, CLEAR_CELLS, ADD_EMPTY_ROW, DUPLICATE_ROWS, LINK_ROWS_TO_DATABASE, DELETE_ROWS);
        final LinkedHashMap<String, JMenuItem> linkedHashMap = new LinkedHashMap<String, JMenuItem>();
        JPopupMenu jPopupMenu = actionUtility.createPopupMenu(stringArray, "CWPNRA EISLD".toCharArray(), linkedHashMap);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                boolean bl = resultSetTableModel.isLinkable();
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    if (!list.contains(entry.getKey())) continue;
                    ((JMenuItem)entry.getValue()).setEnabled(bl);
                }
                boolean bl2 = resultSetTableModel.isUpdatable();
                ((JMenuItem)linkedHashMap.get(WindowLaunchHelper1.INSERT_FROM_CLIPBOARD)).setEnabled(bl2);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        resultSetTable.setComponentPopupMenu(jPopupMenu);
        JTableHeader jTableHeader = resultSetTable.getTableHeader();
        JPopupMenu jPopupMenu2 = actionUtility.createPopupMenu(new String[]{COPY, COPY_WITH_ESCAPE, COPY_COLUMN_NAMES, ADD_EMPTY_ROW, INSERT_FROM_CLIPBOARD}, "CWNEI".toCharArray());
        final Point point = new Point();
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction(Resource.getString("Action.sort", Character.valueOf('S'))){

            public void actionPerformed(ActionEvent actionEvent) {
                windowOutputProcessor.sortTable(resultSetTable.getTableHeader().columnAtPoint(point));
            }
        });
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                point.setLocation(mouseEvent.getPoint());
            }
        });
        jMenuItem.setMnemonic('S');
        jPopupMenu2.insert(jMenuItem, 0);
        jTableHeader.setComponentPopupMenu(jPopupMenu2);
        ResultSetTable.RowHeader rowHeader = resultSetTable.getRowHeader();
        rowHeader.setComponentPopupMenu(jPopupMenu);
    }

    static void bindEvents(final ConsoleTextArea consoleTextArea, final WindowLauncher windowLauncher) {
        ActionUtility actionUtility = ActionUtility.getInstance(consoleTextArea);
        consoleTextArea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                windowLauncher.executeCommand(actionEvent.getActionCommand());
            }
        });
        consoleTextArea.setDropTarget(new DropTarget(consoleTextArea, new DropTargetAdapter(){

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                List list;
                Object object;
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    try {
                        object = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        list = object;
                    }
                    catch (Exception exception) {
                        WindowLaunchHelper3.handleError(exception, null);
                        return;
                    }
                } else {
                    throw new IllegalStateException("Transferable=" + transferable);
                }
                object = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(new AbstractAction(Resource.getString("Action.paste-path", Character.valueOf('P'))){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = Iteration.join(list, " ");
                        int n = consoleTextArea.getCaretPosition();
                        if (consoleTextArea.isEditablePosition(n)) {
                            consoleTextArea.insert(string, n);
                        } else {
                            consoleTextArea.append(string, false);
                        }
                    }
                });
                jMenuItem.setMnemonic('P');
                ((JPopupMenu)object).add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction(Resource.getString("Action.paste-file-content", Character.valueOf('F'))){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            for (File file : list) {
                                if (file.length() <= 0L) continue;
                                String string = this.convertContentToString(file);
                                int n = consoleTextArea.getCaretPosition();
                                if (consoleTextArea.isEditablePosition(n)) {
                                    consoleTextArea.insert(string, n);
                                    continue;
                                }
                                consoleTextArea.append(string, false);
                            }
                        }
                        catch (IOException iOException) {
                            WindowLaunchHelper3.handleError(iOException, null);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private String convertContentToString(File file) throws IOException {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        FileInputStream fileInputStream = new FileInputStream(file);
                        try {
                            fileInputStream.getChannel().transferTo(0L, file.length(), Channels.newChannel(byteArrayOutputStream));
                        }
                        finally {
                            fileInputStream.close();
                        }
                        return byteArrayOutputStream.toString();
                    }
                });
                jMenuItem2.setMnemonic('F');
                ((JPopupMenu)object).add(jMenuItem2);
                Point point = dropTargetDropEvent.getLocation();
                ((JPopupMenu)object).show(consoleTextArea, point.x, point.y);
            }
        }));
        actionUtility.setActionForTextComponent();
    }
}

