/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ConnectorDriverManager;
import net.argius.stew.DynamicLoader;
import net.argius.stew.Password;
import net.argius.stew.PlainTextPassword;

public final class Connector {
    private static final Logger log = LoggerFactory.getLogger(Connector.class);
    private final String id;
    private final Properties props;
    private final Password password;
    private transient Driver driver;

    public Connector(String string, Properties properties) {
        assert (string != null);
        if (!string.matches("[A-Za-z0-9]+")) {
            throw new IllegalArgumentException("illegal id : " + string);
        }
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Password password = Connector.createPasswordInstance(properties.getProperty("password.class"));
        password.setTransformedString(properties.getProperty("password"));
        this.id = string;
        this.props = properties2;
        this.password = password;
    }

    private static Password createPasswordInstance(String string) {
        if (string != null) {
            try {
                return (Password)DynamicLoader.newInstance(string);
            }
            catch (Exception exception) {
                log.warn("", exception);
            }
        }
        return new PlainTextPassword();
    }

    public Connector(String string, Connector connector) {
        this(string, new Properties(connector.props));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.props.getProperty("name");
    }

    public String getClasspath() {
        return this.props.getProperty("classpath", "");
    }

    public String getDriver() {
        String string = this.props.getProperty("driver");
        if (log.isDebugEnabled()) {
            log.debug(String.format("driver=[%s]", string));
        }
        return string;
    }

    public String getUrl() {
        return this.props.getProperty("url");
    }

    public String getUser() {
        return this.props.getProperty("user");
    }

    public Password getPassword() {
        return this.password;
    }

    public boolean isReadOnly() {
        String string = this.props.getProperty("readonly");
        return Boolean.valueOf(string);
    }

    public boolean usesAutoRollback() {
        String string = this.props.getProperty("rollback");
        return Boolean.valueOf(string);
    }

    public Properties toProperties() {
        return (Properties)this.props.clone();
    }

    public Connection getConnection() throws SQLException {
        if (this.driver == null) {
            this.driver = ConnectorDriverManager.getDriver(this.getUrl(), this.getDriver(), this.getClasspath());
            if (this.driver == null) {
                throw new SQLException("failed to load driver");
            }
            if (log.isDebugEnabled()) {
                log.debug(this.driver);
            }
        }
        Properties properties = new Properties();
        properties.setProperty("user", this.getUser());
        properties.setProperty("password", this.getPassword().getRowString());
        if (!this.driver.acceptsURL(this.getUrl())) {
            throw new SQLException("invalid url: " + this.getUrl());
        }
        if (log.isInfoEnabled()) {
            log.info("driver.connect start");
        }
        Connection connection = this.driver.connect(this.getUrl(), properties);
        if (log.isInfoEnabled()) {
            log.info("driver.connect end");
        }
        if (connection == null) {
            throw new IllegalStateException("driver returned null");
        }
        return connection;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.props == null ? 0 : this.props.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Connector)) {
            return false;
        }
        Connector connector = (Connector)object;
        return this.props.equals(connector.props);
    }

    public String toString() {
        return "Connector:" + this.id;
    }
}

