/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import java.io.*;

/**
 * GNX|[g̊NXB
 * 
 * IɑI(getExporter)ꍇA
 * t@C`͈ȉ̂悤Ɋgqɂ莩IɑIB
 * <ul>
 * <li>gq"xml"̏ꍇXML`(stew-table.dtd)ŏo͂B
 * <li>gq"htm""html"̏ꍇHTML`ŏo͂B
 * <li>gq"csv"̏ꍇCSV`ŏo͂B
 * <li>LȊȌꍇ̓^u؂`ŏo͂B
 * </ul>
 */
public abstract class Exporter {

    protected OutputStream os;
    protected boolean wasWrittenHeader;

    private boolean closed;

    /**
     * RXgN^B
     * @param os OutputStream
     */
    protected Exporter(OutputStream os) {
        this.os = os;
        this.wasWrittenHeader = false;
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    protected final void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream closed");
        }
    }

    /**
     * wb_ǉB
     * ǉ͈xsȂB
     * @param header wb_
     * @throws IOException wb_ǉׂłȂꍇA
     *                     ͂̑̓o̓G[
     */
    public void addHeader(Object[] header) throws IOException {
        ensureOpen();
        if (wasWrittenHeader) {
            throw new IOException("header was already written");
        }
        writeHeader(header);
        wasWrittenHeader = true;
    }

    /**
     * wb_ށB
     * @param header wb_
     * @throws IOException
     */
    protected void writeHeader(Object[] header) throws IOException {
        ensureOpen();
        addRow(header);
    }

    /**
     * IB
     * @throws IOException
     */
    public void close() throws IOException {
        ensureOpen();
        if (os != null) {
            try {
                os.close();
            } finally {
                os = null;
            }
        }
    }

    /**
     * ExporterIɑIĎ擾B
     * @param file t@C
     * @return Exporter
     * @throws IOException
     */
    public static Exporter getExporter(File file) throws IOException {
        return ExporterFactory.createExporter(new Path(file));
    }

    /**
     * ExporterIɑIĎ擾B
     * @param fileName t@C
     * @return Exporter
     * @throws IOException
     */
    public static Exporter getExporter(String fileName) throws IOException {
        return ExporterFactory.createExporter(new Path(fileName));
    }

    /**
     * sǉB
     * @param values l
     * @throws IOException
     */
    public abstract void addRow(Object[] values) throws IOException;

}