/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.console;

import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.Map.*;

import net.argius.stew.*;

/**
 * R\[[h̐ڑݒGfB^B
 */
public final class ConnectorMapEditor {

    private static final String[] PROP_KEYS = {"name", "classpath", "driver", "url", "user",
                                               "password", "readonly", "rollback"};

    private final ConnectorMap map;

    private ConnectorMap oldContent;

    private ConnectorMapEditor() throws IOException {
        ConnectorMap m;
        try {
            m = ConnectorConfiguration.load();
        } catch (FileNotFoundException ex) {
            printMessage("main.notice.filenotexists");
            printLine(String.format("(%s)", ex.getMessage()));
            m = new ConnectorMap();
        }
        this.oldContent = m;
        this.map = new ConnectorMap(this.oldContent);
    }

    /**
     * ݒ̏ڍד͂B
     * @param id ύXRlN^ID
     * @param props RlN^ݒ
     * @return ύXꍇ <code>true</code>AłȂ <code>false</code>
     */
    private boolean proceedInputProperties(String id, Properties props) {
        while (true) {
            printMessage("property.start1");
            printMessage("property.start2");
            for (String key : PROP_KEYS) {
                String value = props.getProperty(key);
                print(getString("property.input", key, value));
                String input = getInput("");
                if (input != null && input.length() > 0) {
                    props.setProperty(key, input);
                }
            }
            for (String key : PROP_KEYS) {
                printLine(key + "=" + props.getProperty(key));
            }
            if (confirmYes("property.tryconnect.confirm")) {
                try {
                    Connector c = new Connector(id, props);
                    c.getConnection();
                    printMessage("property.tryconnect.succeeded");
                } catch (SQLException ex) {
                    printMessage("property.tryconnect.failed", ex.getMessage());
                }
            }
            if (confirmYes("property.update.confirm")) {
                return true;
            }
            if (!confirmYes("property.retry.confirm")) {
                printMessage("property.update.cancel");
                return false;
            }
        }
    }

    /**
     * ǉB
     * @param id ǉRlN^ID
     */
    private void proceedAdd(String id) {
        if (map.containsKey(id)) {
            printMessage("proc.alreadyexists", id);
            return;
        }
        Properties props = new Properties();
        // ftHgl
        for (String key : PROP_KEYS) {
            props.setProperty(key, "");
        }
        if (proceedInputProperties(id, props)) {
            map.put(id, new Connector(id, props));
            printMessage("proc.added", id);
        }
    }

    /**
     * ύXB
     * @param id ύXRlN^ID
     */
    private void proceedModify(String id) {
        if (!map.containsKey(id)) {
            printMessage("proc.notexists", id);
            return;
        }
        Properties props = map.getConnector(id).toProperties();
        if (proceedInputProperties(id, props)) {
            map.put(id, new Connector(id, props));
            printMessage("proc.modified", id);
        }
    }

    /**
     * 폜B
     * @param id 폜RlN^ID
     */
    private void proceedRemove(String id) {
        Connector connector = map.getConnector(id);
        printLine("ID[" + id + "]:" + connector.getName());
        if (confirmYes("proc.remove.confirm")) {
            map.remove(id);
            printMessage("proc.remove.finished");
        } else {
            printMessage("proc.remove.canceled");
        }
        printLine(map);
    }

    /**
     * Rs[B
     * @param src Rs[
     * @param dst Rs[
     */
    private void proceedCopy(String src, String dst) {
        if (!map.containsKey(src)) {
            printMessage("proc.notexists", src);
            printMessage("proc.copy.canceled");
            return;
        }
        if (map.containsKey(dst)) {
            printMessage("proc.alreadyexists", dst);
            printMessage("proc.copy.canceled");
            return;
        }
        map.put(dst, new Connector(dst, map.getConnector(src)));
        printMessage("proc.copy.finished");
    }

    /**
     * ݂IDꗗ\B
     */
    private void proceedDisplayIds() {
        for (Entry<String, Connector> entry : map.entrySet()) {
            String id = entry.getKey();
            printLine(String.format("%10s : %s", id, map.getConnector(id).getName()));
        }
    }

    /**
     * w肳ꂽID̏ڍׂ\B
     * @param id ID
     */
    private void proceedDisplayDetail(String id) {
        if (!map.containsKey(id)) {
            printMessage("proc.notexists", id);
            return;
        }
        Properties props = map.getConnector(id).toProperties();
        for (String key : PROP_KEYS) {
            printLine(String.format("%10s : %s", key, props.getProperty(key)));
        }
    }

    /**
     * ݂̓et@CɕۑB
     * @throws IOException
     */
    private void proceedSave() throws IOException {
        if (map.equals(oldContent)) {
            printMessage("proc.nomodification");
        } else if (confirmYes("proc.save.confirm")) {
            ConnectorConfiguration.save(map);
            oldContent = new ConnectorMap(map);
            printMessage("proc.save.finished");
        } else {
            printMessage("proc.save.canceled");
        }
    }

    /**
     * t@C݂̓eɓǂݍށB
     * ݒ蒆̓e͔jimFjB
     * @throws IOException
     */
    private void proceedLoad() throws IOException {
        ConnectorMap m = ConnectorConfiguration.load();
        if (m.equals(oldContent) && m.equals(map)) {
            printMessage("proc.nomodification");
            return;
        }
        printMessage("proc.load.confirm1");
        if (confirmYes("proc.load.confirm2")) {
            map.clear();
            map.putAll(ConnectorConfiguration.load());
            printMessage("proc.load.finished");
        } else {
            printMessage("proc.load.canceled");
        }
    }

    /**
     * W͂̓͂𕶎ƂĎ擾B
     * @param messageId bZ[WID(bZ[Ww肵Ȃꍇ͋󕶎)
     * @param args MessageFormatɓn 
     * @return ͂ꂽ(Knullł͂Ȃ)
     */
    private static String getInput(String messageId, Object... args) {
        if (messageId.length() > 0) {
            print(getString(messageId, args));
        }
        print(getString("proc.prompt"));
        Scanner scanner = new Scanner(System.in);
        if (scanner.hasNextLine()) {
            return scanner.nextLine();
        }
        return "";
    }

    /**
     * mFʂԂB
     * @param messageId bZ[WID(bZ[Ww肵Ȃꍇ͋󕶎)
     * @param args MessageFormatɓn 
     * @return <code>y</code>(Yes)̏ꍇ <code>true</code>A
     *         łȂ <code>false</code>
     */
    private static boolean confirmYes(String messageId) {
        if (messageId.length() > 0) {
            print(getString(messageId));
        }
        print("(y/N)");
        return getInput("").equalsIgnoreCase("y");
    }

    /**
     * Wo͂ɉsȂŏo͂B
     * @param o IuWFNg
     */
    private static void print(Object o) {
        System.out.print(o);
    }

    /**
     * Wo͂ɉŝݏo͂B
     */
    private static void printLine() {
        System.out.println();
    }

    /**
     * Wo͂ɉsŏo͂B
     * @param o IuWFNg
     */
    private static void printLine(Object o) {
        System.out.println(o);
    }

    /**
     * bZ[Wo͂B
     * @param messageId bZ[WID
     * @param args MessageFormatɓn
     */
    private static void printMessage(String messageId, Object... args) {
        printLine(getString(messageId, args));
    }

    /**
     * O̎擾
     * @param messageId bZ[WID
     * @return 
     */
    private static String getString(String messageId, Object... args) {
        return Resource.getString("ConnectorMapEditor." + messageId, args);
    }

    /**
     * GfB^NB
     */
    static void invoke() {
        printLine();
        printMessage("main.start");
        printLine();
        try {
            ConnectorMapEditor editor = new ConnectorMapEditor();
            while (true) {
                Parameter p = new Parameter(getInput("main.wait"));
                final String command = p.at(0);
                final String id = p.at(1);
                if (command.equalsIgnoreCase("help")) {
                    printMessage("help");
                } else if (command.equalsIgnoreCase("a")) {
                    editor.proceedAdd(id);
                } else if (command.equalsIgnoreCase("m")) {
                    editor.proceedModify(id);
                } else if (command.equalsIgnoreCase("r")) {
                    editor.proceedRemove(id);
                } else if (command.equalsIgnoreCase("copy")) {
                    editor.proceedCopy(id, p.at(2));
                } else if (command.equalsIgnoreCase("disp")) {
                    if (id.length() == 0) {
                        editor.proceedDisplayIds();
                    } else {
                        editor.proceedDisplayDetail(id);
                    }
                } else if (command.equalsIgnoreCase("save")) {
                    editor.proceedSave();
                } else if (command.equalsIgnoreCase("load")) {
                    editor.proceedLoad();
                } else if (command.equalsIgnoreCase("exit")) {
                    if (editor.map.equals(editor.oldContent)) {
                        break;
                    } else if (confirmYes("proc.exit.confirm")) {
                        break;
                    }
                }
                printLine();
            }
        } catch (Throwable th) {
            th.printStackTrace();
        }
        printLine();
        printMessage("main.end");
    }

    /**
     * R}hGfB^JnB
     * @param args (gp)
     */
    public static void main(String... args) {
        printLine(Resource.getString("i.about", Resource.getVersion()));
        invoke();
    }

}
