/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.text;

import static java.util.FormattableFlags.LEFT_JUSTIFY;

import java.util.*;

/**
 * }`oCgƑSp̕ltH[}bgB
 */
public final class PrintFormat {

    /**
     * tH[}bgB
     * @param format tH[}bg
     * @param args p[^
     * @return tH[}bgꂽ
     */
    public static String format(String format, Object... args) {
        List<Object> a = new ArrayList<Object>();
        for (Object arg : args) {
            final Object o;
            if (arg == null || arg instanceof CharSequence) {
                o = new FullwidthFormatter((arg == null) ? "" : arg.toString());
            } else {
                o = arg;
            }
            a.add(o);
        }
        try {
            return String.format(format, a.toArray());
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /**
     * SptH[}bgB
     */
    private static final class FullwidthFormatter implements Formattable {

        private static final char SPACE = ' ';

        private final char[] chars;
        private final int length;

        FullwidthFormatter(String string) {
            this.chars = string.toCharArray();
            this.length = chars.length;
        }

        /* @see java.util.Formattable#formatTo(java.util.Formatter, int, int, int) */
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            final boolean leftJustify = (flags & LEFT_JUSTIFY) == LEFT_JUSTIFY;
            StringBuilder buffer = new StringBuilder(width);
            int count = 0;
            for (int i = 0; i < length; i++) {
                final int index = leftJustify ? i : length - 1 - i;
                char c = chars[index];
                if (leftJustify) {
                    buffer.append(c);
                } else {
                    buffer.insert(0, c);
                }
                final int w = getWidth(c);
                if (++count >= width) {
                    if (w == 2) {
                        buffer.setCharAt(index, SPACE);
                    }
                    break;
                }
                if (w == 2) {
                    ++count;
                }
            }
            if (count < width) {
                char[] chars = new char[width - count];
                Arrays.fill(chars, SPACE);
                if (leftJustify) {
                    buffer.append(chars);
                } else {
                    buffer.insert(0, chars);
                }
            }
            formatter.format(buffer.toString());
        }

        private static int getWidth(char ch) {
            // U+0000bU+00FFFp
            // U+FF61bU+FF9FFpJ^Ji
            // LȊO          FSp
            return (ch > '\u00FF' && (ch < '\uFF61' || ch > '\uFF9F')) ? 2 : 1;
        }

    }

}
