/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.AnonymousConnector;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Connector;
import net.argius.stew.DynamicLoader;
import net.argius.stew.DynamicLoadingException;
import net.argius.stew.Environment;
import net.argius.stew.Parameter;
import net.argius.stew.Resource;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;
import net.argius.stew.ui.OutputProcessor;

final class CommandProcessor {
    private static final Logger log = LoggerFactory.getLogger(CommandProcessor.class);
    private static final String HYPHEN_E = "-e";
    private final Environment env;
    private final OutputProcessor op;

    CommandProcessor(Environment environment) {
        this.env = environment;
        this.op = environment.getOutputProcessor();
    }

    boolean invoke(String string) throws CommandException {
        Throwable throwable;
        Parameter parameter = new Parameter(string);
        if (string.replaceFirst("^\\s+", "").startsWith(HYPHEN_E)) {
            int n = string.indexOf(HYPHEN_E) + 2;
            for (String string2 : string.substring(n).split(HYPHEN_E)) {
                this.op.output(" >> " + string2);
                if (this.invoke(string2)) continue;
                this.outputMessage("w.exit-not-available-in-sequencial-command", new Object[0]);
            }
            return true;
        }
        String string3 = parameter.at(0);
        try {
            return this.invoke(string3, new Parameter(string));
        }
        catch (UsageException usageException) {
            this.outputMessage("e.usage", string3, usageException.getMessage());
        }
        catch (DynamicLoadingException dynamicLoadingException) {
            log.error("", dynamicLoadingException);
            this.outputMessage("e.not-found", string3);
        }
        catch (CommandException commandException) {
            log.error("", commandException);
            throwable = commandException.getCause();
            String string4 = throwable == null ? commandException.getMessage() : throwable.getMessage();
            this.outputMessage("e.command", string4);
        }
        catch (IOException iOException) {
            log.error("", iOException);
            this.outputMessage("e.command", iOException.getMessage());
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            log.error("", sQLException);
            throwable = sQLException;
            while ((sQLException2 = ((SQLException)throwable).getNextException()) != null && sQLException2 != throwable) {
                log.error("------ SQLException.getNextException ------", sQLException2);
                throwable = sQLException2;
            }
            this.outputMessage("e.database", sQLException.getMessage());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.warn("", unsupportedOperationException);
            this.outputMessage("e.unsupported", unsupportedOperationException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            log.error("", runtimeException);
            this.outputMessage("e.runtime", runtimeException.getMessage());
        }
        catch (Throwable throwable2) {
            log.fatal("", throwable2);
            this.outputMessage("e.fatal", throwable2.getMessage());
        }
        try {
            boolean bl;
            Connection connection = this.env.getCurrentConnection();
            if (connection != null && (bl = connection.isClosed())) {
                if (log.isInfoEnabled()) {
                    log.info("connection is already closed");
                }
                this.disconnect();
            }
        }
        catch (SQLException sQLException) {
            log.warn("", sQLException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invoke(String string, Parameter parameter) throws IOException, SQLException {
        assert (string != null);
        if (string.length() == 0) {
            return true;
        }
        if (string.equalsIgnoreCase("exit")) {
            this.disconnect();
            this.outputMessage("i.exit", new Object[0]);
            return false;
        }
        if (string.equalsIgnoreCase("connect") || string.equalsIgnoreCase("-c")) {
            this.connect(parameter);
            return true;
        }
        if (string.equals("-f")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            File file = new File(parameter.at(1));
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                fileInputStream.getChannel().transferTo(0L, file.length(), Channels.newChannel(byteArrayOutputStream));
            }
            finally {
                fileInputStream.close();
            }
            this.invoke(String.format("%s%s", byteArrayOutputStream, parameter.after(2)));
            return true;
        }
        if (string.equalsIgnoreCase("cd")) {
            if (!parameter.has(1)) {
                throw new UsageException(Resource.getString("usage.cd", new Object[0]));
            }
            File file = this.env.getCurrentDirectory();
            String string2 = parameter.at(1);
            File file2 = new File(string2);
            File file3 = (file2.isAbsolute() ? file2 : new File(file, string2)).getCanonicalFile();
            if (!file3.isDirectory()) {
                this.outputMessage("e.dir-not-exists", file3);
                return true;
            }
            this.env.setCurrentDirectory(file3);
            this.outputMessage("i.directory-changed", file.getAbsolutePath(), file3.getAbsolutePath());
            return true;
        }
        if (string.equals("@")) {
            this.op.output(String.format("current dir : %s", this.env.getCurrentDirectory().getAbsolutePath()));
            this.op.output(String.format("system  dir : %s", this.env.getSystemDirectory().getAbsolutePath()));
            return true;
        }
        if (string.equals("-")) {
            return this.invoke("report -");
        }
        Connection connection = this.env.getCurrentConnection();
        if (connection == null) {
            this.outputMessage("e.not-connect", new Object[0]);
        } else if (string.equalsIgnoreCase("disconnect") || string.equalsIgnoreCase("-d")) {
            this.disconnect();
            this.outputMessage("i.disconnected", new Object[0]);
        } else if (string.equalsIgnoreCase("commit")) {
            connection.commit();
            this.outputMessage("i.committed", new Object[0]);
        } else if (string.equalsIgnoreCase("rollback")) {
            connection.rollback();
            this.outputMessage("i.rollbacked", new Object[0]);
        } else {
            this.executeDynamicCommand(string, connection, parameter);
        }
        return true;
    }

    private void connect(Parameter parameter) throws SQLException {
        if (log.isInfoEnabled()) {
            log.info("connect start");
        }
        this.disconnect();
        String string = parameter.at(1);
        Connector connector = !parameter.has(1) ? AnonymousConnector.getConnector(string, parameter.at(2), parameter.at(3)) : (string.indexOf(64) >= 0 ? AnonymousConnector.getConnector(string) : this.env.getConnectorMap().getConnector(string));
        if (connector != null) {
            boolean bl;
            Connection connection = connector.getConnection();
            try {
                if (connector.isReadOnly()) {
                    connection.setReadOnly(true);
                }
            }
            catch (RuntimeException runtimeException) {
                log.warn("", runtimeException);
            }
            try {
                connection.setAutoCommit(false);
                bl = connection.getAutoCommit();
            }
            catch (RuntimeException runtimeException) {
                log.warn("", runtimeException);
                bl = false;
            }
            if (bl) {
                this.outputMessage("w.auto-commit-not-available", new Object[0]);
            }
            this.env.setCurrentConnection(connection);
            this.env.setCurrentConnector(connector);
            this.outputMessage("i.connected", new Object[0]);
        } else {
            this.outputMessage("e.no-connector", string);
        }
        if (log.isInfoEnabled()) {
            log.info("connect end");
        }
    }

    private void disconnect() {
        if (log.isDebugEnabled()) {
            log.debug("disconnect start");
        }
        try {
            this.env.releaseConnection();
        }
        catch (SQLException sQLException) {
            this.outputMessage("w.connection-closed-abnormally", new Object[0]);
        }
        if (log.isDebugEnabled()) {
            log.debug("disconnect end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDynamicCommand(String string, Connection connection, Parameter parameter) {
        Class<Object> clazz;
        assert (string != null && !string.contains(" "));
        String string2 = string.indexOf(46) > 0 ? string : "net.argius.stew.command." + string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
        try {
            clazz = DynamicLoader.loadClass(string2);
        }
        catch (DynamicLoadingException dynamicLoadingException) {
            clazz = Command.isSelect(string) ? Select.class : UpdateAndOthers.class;
        }
        Command command = (Command)DynamicLoader.newInstance(clazz);
        try {
            Connector connector = this.env.getCurrentConnector();
            if (connector.isReadOnly() && !command.isReadOnly()) {
                this.outputMessage("e.readonly", new Object[0]);
                return;
            }
            command.setEnvironment(this.env);
            if (log.isInfoEnabled()) {
                log.info("command: " + command + " start");
            }
            if (log.isDebugEnabled()) {
                log.debug(parameter);
            }
            command.initialize();
            command.execute(connection, parameter);
        }
        finally {
            command.close();
        }
        if (log.isInfoEnabled()) {
            log.info("command: " + command + " end");
        }
    }

    void outputMessage(String string, Object ... objectArray) throws CommandException {
        this.op.output(Resource.getString(string, objectArray));
    }

    static final class UpdateAndOthers
    extends RawSQL {
        public boolean isReadOnly() {
            return false;
        }

        protected void execute(Statement statement, String string) throws SQLException {
            int n = this.executeUpdate(statement, string);
            String string2 = string.matches("(?i)\\s*UPDATE.*") ? "i.updated" : (string.matches("(?i)\\\\s*INSERT.*") ? "i.inserted" : (string.matches("(?i)\\\\s*DELETE.*") ? "i.deleted" : "i.proceeded"));
            this.outputMessage(string2, n);
        }
    }

    static final class Select
    extends RawSQL {
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Statement statement, String string) throws SQLException {
            long l = System.currentTimeMillis();
            ResultSet resultSet = this.executeQuery(statement, string);
            try {
                this.outputMessage("i.response-time", Float.valueOf((float)(System.currentTimeMillis() - l) / 1000.0f));
                ResultSetReference resultSetReference = new ResultSetReference(resultSet, this.getRawString());
                this.output(resultSetReference);
                this.outputMessage("i.selected", resultSetReference.getRecordCount());
            }
            finally {
                resultSet.close();
            }
        }
    }

    static abstract class RawSQL
    extends Command {
        private String rawString;

        RawSQL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute(Connection connection, Parameter parameter) throws CommandException {
            this.rawString = parameter.asString();
            try {
                Statement statement = this.prepareStatement(connection, this.rawString);
                try {
                    this.execute(statement, this.rawString);
                }
                finally {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                throw new CommandException(sQLException);
            }
        }

        protected String getRawString() {
            return this.rawString;
        }

        protected abstract void execute(Statement var1, String var2) throws SQLException;
    }
}

