/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Scanner;
import javax.swing.ImageIcon;
import net.argius.stew.LocalSystem;

final class Resource {
    static final String EMPTY_STRING = "";
    static final String EOL = "\n";
    static final String TAB = "\t";
    private static final String BUNDLE_NAME = Resource.class.getPackage().getName() + ".messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

    private Resource() {
    }

    static String getString(String string, Object ... objectArray) {
        try {
            String string2 = RESOURCE_BUNDLE.getString(string);
            if (objectArray.length == 0) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return String.format("?(%s,%s)", string, Arrays.asList(objectArray));
        }
    }

    static ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Resource.class.getResource(string));
        }
        catch (RuntimeException runtimeException) {
            return new ImageIcon();
        }
    }

    static int getMenuShortcutKeyMask() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getVersion() {
        InputStream inputStream = LocalSystem.class.getResourceAsStream("version");
        try {
            Scanner scanner = new Scanner(inputStream);
            String string = scanner.nextLine();
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

