/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.UsageException;

public final class Download
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Download.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(3)) {
            throw new UsageException(this.getUsage());
        }
        String string = parameter.get(2);
        String string2 = parameter.getAll(3);
        if (log.isDebugEnabled()) {
            log.debug("root: " + string);
            log.debug("SQL: " + string2);
        }
        try {
            Statement statement = connection.createStatement();
            try {
                ResultSet resultSet = statement.executeQuery(string2);
                try {
                    this.download(resultSet, string);
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
        }
        catch (IOException iOException) {
            throw new CommandException(iOException);
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(ResultSet resultSet, String string) throws IOException, SQLException {
        boolean bl;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        assert (n >= 1);
        int n2 = resultSetMetaData.getColumnType(1);
        switch (n2) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        byte[] byArray = new byte[8192];
        int n3 = 0;
        while (resultSet.next()) {
            ++n3;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 2; i <= n; ++i) {
                stringBuilder.append(resultSet.getString(i));
            }
            InputStream inputStream = bl ? resultSet.getBinaryStream(1) : resultSet.getAsciiStream(1);
            try {
                File file;
                File file2 = this.resolvePath(string);
                File file3 = file = n == 1 ? file2 : new File(file2, stringBuilder.toString());
                if (file.exists()) {
                    throw new IOException(this.getMessage("e.file-already-exists", file.getAbsolutePath()));
                }
                File file4 = file.getParentFile();
                if (!file4.isDirectory()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("mkdir [%s]", file4.getAbsolutePath()));
                    }
                    if (file4.mkdirs()) {
                        this.outputMessage("i.did-mkdir", file4);
                    } else {
                        throw new IOException(this.getMessage("e.failed-mkdir-filedir", file));
                    }
                }
                long l = 0L;
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    int n4;
                    while ((n4 = inputStream.read(byArray)) > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n4);
                        l += (long)n4;
                    }
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
                this.outputMessage("i.downloaded", Float.valueOf((float)l / 1024.0f), file);
            }
            finally {
                inputStream.close();
            }
        }
        this.outputMessage("i.selected", n3);
    }
}

