using System;
using System.Collections.Generic;
using System.Text;

namespace StarEngine.Core
{
    /// <summary>
    /// 色調を表します。
    /// </summary>
    public struct Tone
    {
        public static Tone Empty
        {
            get { return new Tone(0, 0, 0); }
        }

        public static bool operator ==(Tone t1, Tone t2)
        {
            return t1.Red == t2.Red && t1.Green == t2.Green &&
                t1.Blue == t2.Blue && t1.Saturation == t2.Saturation;
        }

        public static bool operator !=(Tone t1, Tone t2)
        {
            return !(t1 == t2);
        }

        public Tone(int red, int green, int blue)
            : this(red, green, blue, 255)
        {
        }

        public Tone(int red, int green, int blue, byte saturation)
        {
            this = new Tone();
            this.Red = red;
            this.Green = green;
            this.Blue = blue;
            this.Saturation = saturation;
        }

        public int Blue
        {
            get { return this.blue; }
            set { this.blue = Math.Max(Math.Min(value, 255), -255); }
        }
        private int blue;

        public override bool Equals(object obj)
        {
            return obj is Tone && this == (Tone)obj;
        }

        public override int GetHashCode()
        {
            return this.Red.GetHashCode() ^ this.Green.GetHashCode() ^
                this.Blue.GetHashCode() ^ this.Saturation.GetHashCode();
        }

        public int Green
        {
            get { return this.green; }
            set { this.green = Math.Max(Math.Min(value, 255), -255); }
        }
        private int green;

        public int Red
        {
            get { return this.red; }
            set { this.red = Math.Max(Math.Min(value, 255), -255); }
        }
        private int red;

        /// <summary>
        /// 彩度を取得または設定します。
        /// </summary>
        public byte Saturation
        {
            get { return this.saturation; }
            set { this.saturation = value; }
        }
        private byte saturation;

        public override string ToString()
        {
            return string.Format("Tone(Red:{0},Green:{1},Blue:{2},Saturation:{3})",
                this.Red, this.Green, this.Blue, this.Saturation);
        }
    }
}
