<?xml version="1.0" encoding="UTF-8"?>
	<!--
		Copyright 2004 SQS Development Team / Community Management Research
		Project. Licensed under the Apache License, Version 2.0 (the
		"License"); you may not use this file except in compliance with the
		License. You may obtain a copy of the License at

		http://www.apache.org/licenses/LICENSE-2.0 Unless required by
		applicable law or agreed to in writing, software distributed under the
		License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
		CONDITIONS OF ANY KIND, either express or implied. See the License for
		the specific language governing permissions and limitations under the
		License.
	-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xml:space="preserve"
	version="1.0">

<xsl:param name="language">en</xsl:param>
	<xsl:param name="internal-destination-prefix-section">Section-</xsl:param>
	<xsl:param name="internal-destination-prefix-question">Question-</xsl:param>
	<xsl:param name="internal-destination-prefix-matrixforms">QuestionMatrix-</xsl:param>
	<xsl:param name="internal-destination-prefix-xform">XForm-</xsl:param>
	<xsl:param name="internal-destination-prefix-svg">SVG-</xsl:param>
	<xsl:param name="start-printing-side">left</xsl:param>
	<!-- left, right -->
	<xsl:param name="show-enqtitle-below-pagenum">true</xsl:param>
	<xsl:param name="sides">duplex</xsl:param>
	<xsl:param name="tumble">true</xsl:param>
	<!-- duplex, tumble -->
	<xsl:param name="qid-label-width">20</xsl:param>
	<xsl:param name="item-form-width">9</xsl:param>
	<xsl:param name="item-label-width">12</xsl:param>
	<!--<xsl:param name="WIDTH">595.2756</xsl:param>-->
	<xsl:param name="WIDTH">500.2756</xsl:param>

	<xsl:param name="show-staple">true</xsl:param>
	<!-- true, false -->
	<xsl:param name="enable-marksheet-mode">true</xsl:param>
	<xsl:param name="enable-marking-example">true</xsl:param>
	<!-- true, false -->

	<xsl:attribute-set name="scan-guide">
		<xsl:attribute name="border-color">red</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="border-width">0mm</xsl:attribute>
		<xsl:attribute name="height">60px</xsl:attribute>
		<xsl:attribute name="width">455px</xsl:attribute>
		<xsl:attribute name="top">0px</xsl:attribute>
		<xsl:attribute name="left">72px</xsl:attribute>
		<xsl:attribute name="padding">0px</xsl:attribute>
		<xsl:attribute name="position">absolute</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="page-number">
		<xsl:attribute name="font-family">Gothic</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="qtitle-below-page-number">
		<xsl:attribute name="font-family">Gothic</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 0.3 + 2" />pt</xsl:attribute>
	</xsl:attribute-set>


	<xsl:variable name="base-font-size-pt">11</xsl:variable>

	<xsl:variable name="fontStyle">Gothic</xsl:variable>

	<xsl:attribute-set name="white">
		<xsl:attribute name="font-color">white</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="small">
		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 0.7" />pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="underline">
		<xsl:attribute name="text-decoration">underline</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h">
		<xsl:attribute name="space-before.optimum">20pt</xsl:attribute>
		<xsl:attribute name="margin-left">0pt</xsl:attribute>
		<xsl:attribute name="padding-top">5pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 1.4" />pt</xsl:attribute>
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="p">
		<xsl:attribute name="space-before">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 1.0" />pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="question">
		<xsl:attribute name="padding-top">4pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="textbox">
		<xsl:attribute name="margin-left">5pt</xsl:attribute>
		<xsl:attribute name="margin-right">5pt</xsl:attribute>
		<xsl:attribute name="padding-top">4pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">4pt</xsl:attribute>
		<xsl:attribute name="padding-left">5pt</xsl:attribute>
		<xsl:attribute name="padding-right">5pt</xsl:attribute>
		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="th-block">
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 0.9" />pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="td-block">
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 0.9" />pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="td-block.item-form">
		<xsl:attribute name="space-before">2pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">2pt</xsl:attribute>
		<xsl:attribute name="padding-right">0pt</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="td-block.item-value">
		<xsl:attribute name="space-before">2pt</xsl:attribute>
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 0.9" />pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="td-block.item-label">
		<xsl:attribute name="space-before">1pt</xsl:attribute>
		<xsl:attribute name="margin-top">3pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">0.5pt</xsl:attribute>
		<xsl:attribute name="margin-right">6pt</xsl:attribute>
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 0.9" />pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="td.matrix-forms-label">
		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="td-block.matrix-forms-label">
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="margin-top">3pt</xsl:attribute>
		<xsl:attribute name="padding-top">3pt</xsl:attribute>
		<xsl:attribute name="margin-left">3pt</xsl:attribute>
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>

		<xsl:attribute name="font-size"><xsl:value-of
			select="number($base-font-size-pt) * 0.9" />pt</xsl:attribute>

		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="td-block.matrix-forms-hint">
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="padding-top">2.5pt</xsl:attribute>
		<xsl:attribute name="padding-left">2.5pt</xsl:attribute>
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of select="number($base-font-size-pt) * 0.9" />pt</xsl:attribute>
		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="td-block.matrix-forms-column-set">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-bottom-color">gray</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="td-block.matrix-forms-column-set-start">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-start-color">gray</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-bottom-color">gray</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="matrix-forms">
		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<!--		<xsl:attribute name="margin-right">10px</xsl:attribute>-->
	</xsl:attribute-set>
	<xsl:attribute-set name="matrix-forms-th">
		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-color">gray</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="matrix-forms-td">
		<xsl:attribute name="margin-top">0pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">0pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-start-color">gray</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-start-color">gray</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="matrix-forms-th-block">
		<xsl:attribute name="font-family"><xsl:value-of select="$fontStyle" /></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of select="number($base-font-size-pt) * 0.66" />pt</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>
</xsl:stylesheet>
