@ECHO OFF
SETLOCAL

SET SQLITE_INC=C:\Documents and Settings\user\My Documents\Visual Studio 2008\Projects\sqlite3jni\sqlite\v3.6.0
SET JAVA_PACKAGE=org.sqlite.swig
SET OUT_DIR=java\org\sqlite\swig
SET COPY_TO=..\src\org\sqlite\swig
SET INTERFACE_FILE=sqlite3jni.i

SET SWIG_BIN=swig.exe
IF NOT "%SWIG_HOME%" == "" SET SWIG_BIN=%SWIG_HOME%\%SWIG_BIN%

REM SET NO_PGCPP=-nopgcpp
REM SET NO_PROXY=-noproxy

IF NOT "%SQLITE_INC%" == "" SET SWIG_INC=-I"%SQLITE_INC%"
IF NOT "%JAVA_PACKAGE%" == "" SET PACKAGE=-package %JAVA_PACKAGE%
IF NOT "%OUT_DIR%" == "" (
    SET OUTDIR=-outdir "%OUT_DIR%"
    IF NOT EXIST "%OUT_DIR%" (MKDIR "%OUT_DIR%") ELSE DEL /Q "%OUT_DIR%\*.java"
)

@ECHO ON
"%SWIG_BIN%" -java %NO_PGCPP% %NO_PROXY% %SWIG_INC% %PACKAGE% %OUTDIR% "%INTERFACE_FILE%"
@ECHO OFF

IF NOT "%ERRORLEVEL%" == "0" GOTO END
IF NOT "%COPY_TO%" == "" (
    DEL /Q "%COPY_TO%\SWIGTYPE*.java"
    DEL /Q "%COPY_TO%\SQLite3*.java"
    COPY /V /Y "%OUT_DIR%\*.java" "%COPY_TO%"
    IF "%ERRORLEVEL%" == "0" RMDIR /S /Q java
)

:END
ENDLOCAL
@ECHO ON
