/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Statement;
import org.sqlite.io.BlobInputStream;
import org.sqlite.swig.SWIGTYPE_p_void;

/**
 *
 * @author calico
 */
public class JdbcBlob implements Blob {
    private final Statement stmt;
    private final SWIGTYPE_p_void blob;
    private final long length;
    private boolean isClosed = false;
    
    public JdbcBlob(Statement stmt, int columnIndex) throws SQLException {
        this.stmt = stmt;
        this.blob = stmt.getBlob(columnIndex);
        this.length = stmt.getByteLength(columnIndex);
    }
    
    // START implements
    public long length() throws SQLException {
        return length;
    }

    public byte[] getBytes(long pos, int len) throws SQLException {
        if (pos < 1) {
            throw new SQLException("Should pos is greater than or equal to 1.", "90J08");
        }
        if (len < 0) {
            throw new SQLException("Should len is greater than or equal to 0.", "90J08");
        }
        if (len == 0) {
            return new byte[0];
        }
        
        if (pos + len > length) {
            len -= ((pos + len) - length - 1);
        }
        
        final byte[] b = new byte[len];
        final InputStream in = getBinaryStream();
        try {
            in.skip(pos - 1);
            in.read(b, 0, len);
            return b;

        } catch (IOException ex) {
            // BlobInputStream doesn't throw IOException
            Logger.getLogger(JdbcBlob.class.getName()).throwing(JdbcBlob.class.getName(), "getBytes(long, int)", ex);
            throw new SQLException(ex.getMessage());
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this, blob, length);
    }

    /**
     * Retrieves by the Boyer-Moore algorithm. 
     * @param pattern
     * @param start
     * @return
     * @throws java.sql.SQLException
     * @see <a href="http://www-igm.univ-mlv.fr/~lecroq/string/node14.html">Boyer-Moore algorithm</a>
     */
    public long position(byte[] pattern, long start) throws SQLException {
        // TODO byte[] ではなく InputStream から検索できるようにする！
        int ret = BM(pattern, getBytes(start, (int) length));
        return (ret > 0 ? (ret + 1) : -1);
    }

    /**
     * invoke position(byte[], long) method.
     * @param pattern
     * @param start
     * @return
     * @throws java.sql.SQLException
     */
    public long position(Blob pattern, long start) throws SQLException {
        return position(pattern.getBytes(1, (int) pattern.length()), start);
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Not supporetd yet.
     * @throws java.sql.SQLException
     */
    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    // END implements

    public void close() {
        isClosed = true;
    }
    
    public boolean isClosed() {
        return (isClosed || stmt.isClosed());
    }
    
    private static int[] preBmBc(byte[] x) {
        final int ASIZE = 1 + Byte.MAX_VALUE - Byte.MIN_VALUE;
        final int[] bmBc = new int[ASIZE];
        final int m = x.length;
        
        for (int i = 0; i < ASIZE; ++i) {
            bmBc[i] = m;
        }
        for (int i = 0; i < m - 1; ++i) {
            bmBc[(x[i] < 0 ? (Byte.MAX_VALUE - x[i]) : x[i])] = m - i - 1;
        }
        return bmBc;
    }

    private static int[] suffixes(byte[] x) {
        final int m = x.length;
        final int[] suff = new int[m];

        suff[m - 1] = m;
        int g = m - 1;
        int f = 0;
        for (int i = m - 2; i >= 0; --i) {
            if (i > g && suff[i + m - 1 - f] < i - g) {
                suff[i] = suff[i + m - 1 - f];
            } else {
                if (i < g) {
                    g = i;
                }
                f = i;
                while (g >= 0 && x[g] == x[g + m - 1 - f]) {
                    --g;
                }
                suff[i] = f - g;
            }
        }
        return suff;
    }

    private static int[] preBmGs(byte[] x) {
        final int[] suff = suffixes(x);
        final int m = x.length;
        final int[] bmGs = new int[m];

        for (int i = 0; i < m; ++i) {
            bmGs[i] = m;
        }
        int j = 0;
        for (int i = m - 1; i >= 0; --i) {
            if (suff[i] == i + 1) {
                for (; j < m - 1 - i; ++j) {
                    if (bmGs[j] == m) {
                        bmGs[j] = m - 1 - i;
                    }
                }
            }
        }
        for (int i = 0; i <= m - 2; ++i) {
            bmGs[m - 1 - suff[i]] = m - 1 - i;
        }
        return bmGs;
    }

    // TODO メソッドをユーティリティクラス化して外部に出す？
    private static int BM(byte[] x, byte[] y) {
        // Preprocessing
        int[] bmGs = preBmGs(x);
        int[] bmBc = preBmBc(x);

        final int m = x.length;
        final int n = y.length;
        final int end = (n - m) + 1;
        
        // Searching
        int j = 0;
        while (j < end) {
            int i = 0;
            for (i = m - 1; i >= 0 && x[i] == y[i + j]; --i) {
                // skip
            }
            if (i < 0) {
                // match
                return j;
//                j += bmGs[0];
            } else {
                final byte b = y[i + j];
                j += Math.max(
                            bmGs[i],
                            bmBc[(b < 0 ? (Byte.MAX_VALUE - b) : b)] - m + 1 + i
                        );
            }
        }
        return -1;
    }
    
}
