package com.ozacc.mail.mailet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ozacc.mail.fetch.ReceivedMail;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MailetWrapper.java,v 1.1.2.1 2005/01/18 07:22:01 otsuka Exp $
 */
public class MailetWrapper {

	private Mailet mailet;

	private List matcherList;

	/**
	 * 󥹥ȥ饯
	 */
	public MailetWrapper() {
		matcherList = new ArrayList();
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param mailet
	 * @param matcherList 
	 */
	public MailetWrapper(Mailet mailet, List matcherList) {
		this();
		this.mailet = mailet;
		this.matcherList = matcherList;
	}

	/**
	 * 
	 * @param mail
	 */
	public void execute(ReceivedMail mail) {
		for (Iterator itr = matcherList.iterator(); itr.hasNext();) {
			Matcher m = (Matcher)itr.next();
			if (!m.match(mail)) {
				return;
			}
		}
		mailet.service(mail);
	}

	/**
	 * @return Returns the mailet.
	 */
	public Mailet getMailet() {
		return mailet;
	}

	/**
	 * @param mailet The mailet to set.
	 */
	public void setMailet(Mailet mailet) {
		this.mailet = mailet;
	}

	/**
	 * @return Returns the matcherList.
	 */
	public List getMatcherList() {
		return matcherList;
	}

	/**
	 * @param matcherList The matcherList to set.
	 */
	public void setMatcherList(List matcherList) {
		this.matcherList = matcherList;
	}
}