package com.ozacc.mail.fetch.impl;

import com.ozacc.mail.MailException;
import com.ozacc.mail.fetch.FetchMail;
import com.ozacc.mail.fetch.ReceivedMail;

/**
 * <code>FetchMail</code>󥿡եμ饹
 * <p>
 * <code>FetchMailProImpl</code>饹˽ѾƤޤ
 * 
 * @since 1.2
 * @see FetchMailProImpl
 * 
 * @author Tomohiro Otsuka
 * @version $Id: FetchMailImpl.java,v 1.1.2.4 2004/10/27 19:42:41 otsuka Exp $
 */
public class FetchMailImpl implements FetchMail {

	//private FetchMailProImpl fetchMailProImpl;
	/** ǥեȤSMTPСlocalhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ǥեȤΥץȥ롣pop3 */
	public static final String DEFAULT_PROTOCOL = "pop3";

	/**
	 * ǥեȤΥݡȡ-1<br>
	 * -1ϥץȥ˱ŬڤʥݡȤꤹ̤͡
	 */
	public static final int DEFAULT_PORT = -1;

	private static final String INBOX_NAME = "INBOX";

	private String host = DEFAULT_HOST;

	private String protocol = DEFAULT_PROTOCOL;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	/**
	 * 󥹥ȥ饯
	 */
	public FetchMailImpl() {}

	/**
	 * @see com.ozacc.mail.fetch.FetchMail#getMails()
	 */
	public ReceivedMail[] getMails() throws MailException {
		return getMails(false);
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMail#getMails(boolean)
	 */
	public ReceivedMail[] getMails(boolean delete) throws MailException {
		FetchMailProImpl fetchMailProImpl = createFetchMailProImpl();
		fetchMailProImpl.connect();
		try {
			ReceivedMail[] mails = fetchMailProImpl.getMails(delete);
			return mails;
		} finally {
			fetchMailProImpl.disconnect();
		}
	}

	/**
	 * о򥻥åȤFetchMailProImpl󥹥󥹤ޤ
	 * 
	 * @return о򥻥åȤFetchMailProImpl󥹥
	 */
	private FetchMailProImpl createFetchMailProImpl() {
		FetchMailProImpl fmp = new FetchMailProImpl();
		fmp.setHost(host);
		fmp.setPort(port);
		fmp.setProtocol(protocol);
		fmp.setUsername(username);
		fmp.setPassword(password);
		return fmp;
	}

	/**
	 * @param host 
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @param password 
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @param port 
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * ᡼˻Ѥץȥ򥻥åȤޤ
	 * ߥݡȤƤץȥϡpop3פȡimapפĤǤ
	 * ǥեȤϡpop3פǤ
	 * <p>
	 * POP3ФؤǧڤAPOPǹԤϡץȥ̾ǤϤޤ󤬡
	 * apopפꤷƤAPOPǧڤѤˤϡJavaMail 1.3.2ʹߤɬפǤ
	 * 
	 * @param protocol ץȥ
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @param username 
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * @return Returns the host.
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @return Returns the password.
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @return Returns the port.
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @return Returns the protocol.
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @return Returns the username.
	 */
	public String getUsername() {
		return username;
	}
}