package com.ozacc.mail.impl;

import java.io.File;
import java.io.IOException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailBuilder;

/**
 * ᡼ǡXMLե뤫Mail󥹥󥹤륯饹
 * <p>
 * XMLɤ߹ݤˡDTDХǡ󤬼¹ԤޤΤXMLǡ(Valid XML Document)ǤʤФޤ
 * ᡼ǡXMLDTDϡ<a href="http://www.ozacc.com/library/dtd/ozacc-mail.dtd">http://www.ozacc.com/library/dtd/ozacc-mail.dtd</a>򻲾ȡ
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailBuilderImpl.java,v 1.5 2004/09/17 23:07:16 otsuka Exp $
 */
public class XMLMailBuilderImpl extends AbstractXMLMailBuilder implements MailBuilder {

	/**
	 * 󥹥ȥ饯
	 */
	public XMLMailBuilderImpl() {
		super();
	}

	/**
	 * @see com.ozacc.mail.MailBuilder#buildMail(java.lang.String)
	 */
	public Mail buildMail(String classPath) throws MailBuildException {
		Document doc;
		try {
			doc = getDocumentFromClassPath(classPath);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}

		return buildMail(doc);
	}

	/**
	 * @see com.ozacc.mail.MailBuilder#buildMail(java.io.File)
	 */
	public Mail buildMail(File file) throws MailBuildException {
		Document doc;
		try {
			doc = getDocumentFromFile(file);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}

		return buildMail(doc);
	}

	/**
	 * DOM DocumentMail󥹥󥹤ޤ
	 * 
	 * @param doc ᡼ǡDOM Document
	 * @return 줿Mail󥹥
	 */
	protected Mail buildMail(Document doc) {
		Element root = doc.getDocumentElement();

		Mail mail = new Mail();
		setReturnPath(root, mail);
		setFrom(root, mail);
		setRecipients(root, mail);
		setReplyTo(root, mail);
		setSubject(root, mail);
		setText(root, mail);

		setHtml(root, mail);

		return mail;
	}

}