package com.ozacc.springframework.mail.javamail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

import org.springframework.mail.javamail.MimeMessageHelper;

/**
 * ܸбMimeMessageHelper饹
 * 
 * @author Tomohiro Otsuka
 * @version $Id: IntlMimeMessageHelper.java,v 1.2 2004/08/03 09:36:31 otsuka Exp $
 */
public class IntlMimeMessageHelper extends MimeMessageHelper {

	/** ISO-2022-JPפʸ */
	protected static final String JIS_ENCODING = "ISO-2022-JP";

	protected boolean multipart = false;

	/**
	 * 
	 * @param mimeMessage
	 * @throws MessagingException
	 */
	public IntlMimeMessageHelper(MimeMessage mimeMessage) throws MessagingException {
		super(mimeMessage);

		setDate();
	}

	/**
	 * 
	 * @param mimeMessage
	 * @param encoding
	 * @throws MessagingException
	 */
	public IntlMimeMessageHelper(MimeMessage mimeMessage, String encoding)
																			throws MessagingException {
		super(mimeMessage, encoding);

		setDate();
	}

	/**
	 * @param mimeMessage
	 * @param multipart
	 * @throws MessagingException 
	 */
	public IntlMimeMessageHelper(MimeMessage mimeMessage, boolean multipart)
																			throws MessagingException {
		super(mimeMessage, multipart);
		this.multipart = multipart;

		setDate();
	}

	/**
	 * @param mimeMessage
	 * @param multipart
	 * @throws MessagingException 
	 */
	public IntlMimeMessageHelper(MimeMessage mimeMessage, boolean multipart, String encoding)
																								throws MessagingException {
		super(mimeMessage, multipart, encoding);
		this.multipart = multipart;

		setDate();
	}

	/**
	 * 򼨤Dateإåꤷޤ
	 * 
	 * @throws MessagingException
	 */
	protected void setDate() throws MessagingException {
		getMimeMessage().setSentDate(new Date());
	}

	/**
	 * ᡼η̾򥻥åȤޤ
	 * <p>
	 * 󥳡ǥ󥰤JIS(ISO-2022-JP)ξϡ󥳡ǥ󥰥बBase64ˤʤ褦ˤƤޤ
	 * ϷӤŤMUAȡQuoted-Printable󥳡ǥ󥰤бƤʤ礬뤫Ǥ
	 * 
	 * @see org.springframework.mail.javamail.MimeMessageHelper#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) throws MessagingException {
		if (getEncoding() != null) {
			if (getEncoding().equalsIgnoreCase(JIS_ENCODING)) {
				try {
					getMimeMessage().setSubject(MimeUtility.encodeText(subject, JIS_ENCODING, "B"));
				} catch (UnsupportedEncodingException e) {
					throw new MessagingException(e.getMessage());
				}
			} else {
				getMimeMessage().setSubject(subject, getEncoding());
			}
		} else {
			getMimeMessage().setSubject(subject);
		}
	}

	/**
	 * Sets the given text directly as content in non-multipart mode
	 * respectively as default body part in multipart mode.
	 * 
	 * @param text text to set
	 * @param html whether to apply content type "text/html" for an
	 * HTML mail, using default content type ("text/plain") else
	 */
	public void setText(final String text, boolean html) throws MessagingException {

		// mimeMultipart
		MimeMultipart mimeMultipart = getMimeMultipart();

		MimePart partToUse = null;
		if (mimeMultipart != null) {
			MimeBodyPart bodyPart = null;

			for (int i = 0; i < mimeMultipart.getCount(); i++) {
				BodyPart bp = mimeMultipart.getBodyPart(i);
				if (bp.getFileName() == null) {
					bodyPart = (MimeBodyPart)bp;
				}
			}

			if (bodyPart == null) {
				MimeBodyPart mimeBodyPart = new MimeBodyPart();
				mimeMultipart.addBodyPart(mimeBodyPart);
				bodyPart = mimeBodyPart;
			}

			partToUse = bodyPart;
		} else {
			partToUse = getMimeMessage();
		}

		if (html) {
			// need to use a javax.activation.DataSource (!) to set a text
			// with content type "text/html"
			partToUse.setDataHandler(new DataHandler(new DataSource() {

				public InputStream getInputStream() throws IOException {
					return new ByteArrayInputStream(getEncoding() != null ? text
							.getBytes(getEncoding()) : text.getBytes());
				}

				public OutputStream getOutputStream() throws IOException {
					throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
				}

				public String getContentType() {
					return getEncoding() == null ? "text/html" : "text/html; charset="
							+ getEncoding();
				}

				public String getName() {
					return "text";
				}
			}));
		} else {
			if (getEncoding() != null) {
				partToUse.setText(text, getEncoding());
				if (getEncoding().equalsIgnoreCase(JIS_ENCODING)) {
					partToUse.setHeader("Content-Transfer-Encoding", "7bit");
				}
			} else {
				partToUse.setText(text);
			}
		}
	}

	/**
	 * ѡ饹ǤprivateСեɤMimeMultipartMimeMessageޤ
	 * 
	 * @return MimeMultipart
	 * @throws MessagingException 
	 */
	protected MimeMultipart getMimeMultipart() throws MessagingException {
		MimeMultipart mimeMultipart = null;
		if (multipart) {
			try {
				mimeMultipart = (MimeMultipart)getMimeMessage().getContent();
			} catch (IOException e) {
				throw new MessagingException(e.getMessage());
			}
		}
		return mimeMultipart;
	}

	/**
	 * ܸΥե̾бƤޤ
	 * <p>
	 * Υե̾Υ󥳡ǥˡRFCȿΤޤ󤬡Mozillaϥ᡼顼ޤᡢMicrosoft OutlookǤɽˡΤäƤޤ
	 * 
	 * @see org.springframework.mail.javamail.MimeMessageHelper#addAttachment(java.lang.String, javax.activation.DataSource)
	 */
	public void addAttachment(String attachmentFilename, DataSource dataSource)
																				throws MessagingException {
		MimeMultipart mimeMultipart = getMimeMultipart();
		if (mimeMultipart == null) {
			throw new IllegalStateException("Cannot add attachment - not in multipart mode");
		}
		MimeBodyPart bodyPart = new MimeBodyPart();
		try {
			bodyPart.setFileName(MimeUtility.encodeText(attachmentFilename, JIS_ENCODING, "B"));
		} catch (UnsupportedEncodingException e) {
			throw new MessagingException(e.getMessage());
		}
		bodyPart.setDataHandler(new DataHandler(dataSource));
		mimeMultipart.addBodyPart(bodyPart);
	}
}