/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.springframework.mail.javamail;

import com.ozacc.springframework.mail.HtmlMailMessage;
import com.ozacc.springframework.mail.MultipartMailMessage;
import com.ozacc.springframework.mail.javamail.IntlJavaMailSenderImpl;
import com.ozacc.springframework.mail.javamail.IntlMimeMessageHelper;
import com.ozacc.springframework.mail.javamail.MultipartJavaMailSender;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MultipartJavaMailSenderImpl
extends IntlJavaMailSenderImpl
implements MultipartJavaMailSender {
    public void send(MultipartMailMessage multiPartMessage) throws MailException {
        this.send(new MultipartMailMessage[]{multiPartMessage});
    }

    public void send(MultipartMailMessage[] multiPartMessages) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            for (int i = 0; i < multiPartMessages.length; ++i) {
                MultipartMailMessage multiPartMessage = multiPartMessages[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending email using the following mail properties [" + (Object)((Object)multiPartMessage) + "]"));
                }
                IntlMimeMessageHelper message = new IntlMimeMessageHelper(this.createMimeMessage(), true, this.charset);
                this.assembleMailHeader(multiPartMessage, message);
                this.setText(multiPartMessage, message);
                File[] attachments = multiPartMessage.getAttachments();
                for (int j = 0; j < attachments.length; ++j) {
                    File file = attachments[j];
                    message.addAttachment(file.getName(), file);
                }
                mimeMessages.add(message.getMimeMessage());
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), (Object[])multiPartMessages);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailParseException((Throwable)ex);
        }
        catch (MessagingException ex) {
            throw new MailParseException((Throwable)ex);
        }
    }

    public void send(HtmlMailMessage htmlMessage) throws MailException {
        this.send(new HtmlMailMessage[]{htmlMessage});
    }

    public void send(HtmlMailMessage[] htmlMessages) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            for (int i = 0; i < htmlMessages.length; ++i) {
                HtmlMailMessage htmlMessage = htmlMessages[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending email using the following mail properties [" + (Object)((Object)htmlMessage) + "]"));
                }
                IntlMimeMessageHelper message = new IntlMimeMessageHelper(this.createMimeMessage(), this.charset);
                this.assembleMailHeader(htmlMessage, message);
                this.createHtmlMessage(htmlMessage, message);
                mimeMessages.add(message.getMimeMessage());
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), (Object[])htmlMessages);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailParseException((Throwable)ex);
        }
        catch (MessagingException ex) {
            throw new MailParseException((Throwable)ex);
        }
    }

    protected void createHtmlMessage(HtmlMailMessage htmlMessage, MimeMessageHelper message) throws MessagingException {
        MimeMessage mimeMessage = message.getMimeMessage();
        MimeMultipart mp = new MimeMultipart("alternative");
        if (htmlMessage.getText() != null) {
            MimeBodyPart textPart = new MimeBodyPart();
            if (message.getEncoding() != null) {
                textPart.setText(htmlMessage.getText() + "\n", message.getEncoding());
                if ("iso-2022-jp".equalsIgnoreCase(this.charset)) {
                    textPart.setHeader("Content-Transfer-Encoding", "7bit");
                }
            } else {
                textPart.setText(htmlMessage.getText());
            }
            mp.addBodyPart((BodyPart)textPart);
        }
        if (htmlMessage.getHtml() != null) {
            MimeBodyPart htmlPart = new MimeBodyPart();
            String contentType = message.getEncoding() == null ? "text/html" : "text/html; charset=" + message.getEncoding();
            htmlPart.setContent((Object)htmlMessage.getHtml(), contentType);
            if ("iso-2022-jp".equalsIgnoreCase(this.charset)) {
                htmlPart.setHeader("Content-Transfer-Encoding", "7bit");
            }
            mp.addBodyPart((BodyPart)htmlPart);
        }
        mimeMessage.setContent((Multipart)mp);
        mimeMessage.saveChanges();
    }
}

