package net.souko105.flashserver.javaee.imp;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;

/**
 * WebApppNX[_[
 * WEB-INF/classesWEB-INF/libjarzip[hΏۂ
 * Ȃ܂B
 * @author AKatayama
 */
public class WebAppClassLoader extends URLClassLoader
{
    private ClassLoader parentClassLoader;
    public WebAppClassLoader(URL[] urls)
    {
        super(urls);
    }
    public WebAppClassLoader(URL[] urls, ClassLoader parent)
    {
        super(urls, parent);
        this.parentClassLoader = parent;
    }
    public WebAppClassLoader(URL[] urls, ClassLoader parent,
            URLStreamHandlerFactory factory)
    {
        super(urls, parent, factory);
        this.parentClassLoader = parent;
    }
    public void setParentClassLoader(ClassLoader loader)
    {
        this.parentClassLoader = loader;
    }
    /**
     * NX[h܂B
     * [hς݃NX邩ǂ
     * Oǂݍ݁ieNX[_[j
     * Oǂݍ݁iONX[_[j
     * Oǂݍ݁ieNX[_[j
     * ̏œǂݍ݂sANXꍇ͂̃NXԂ܂B
     * ONX[_[́AWEB-INF/classesWEB-INF/lib[hΏۂɂȂ܂B
     */
    protected synchronized Class loadClass(String name, boolean resolve)
            throws ClassNotFoundException
    {
    	//[hς݃NX`FbN
    	Class c = findLoadedClass(name);
    	if(c != null)
    	{
        	if (resolve)
        	    resolveClass(c);
        	return c;
    	}

	    //VXeNX̃[h
//        try 
//        {
//            c = systemClassLoader.loadClass(name);
//            if(c != null) 
//            {
//                if (resolve)
//                    resolveClass(c);
//                return c;
//            }
//        } 
//        catch (ClassNotFoundException e) {}
	    
        boolean preDelegateLoad = preDelegateLoad(name);
        
        if(preDelegateLoad)
        {
    	    try
    	    {
    	        c = parentClassLoader.loadClass(name);
                if(c != null) 
                {
                    if (resolve)
                        resolveClass(c);
                    return c;
                }
    	    }
    	    catch(Throwable e){}
        }
        
	    try
	    {
	        //ȂΎO[h
	        c = findClass(name);
            if(c != null) 
            {
                if (resolve)
                    resolveClass(c);
                return c;
            }
	    }
	    catch(Throwable e){}
	    
        //Ȃꍇ͈Ϗ
        c = parentClassLoader.loadClass(name);
        if(c != null) 
        {
            if (resolve)
                resolveClass(c);
            return c;
        }
        throw new ClassNotFoundException("Class not found.classname="+name);
    }
    
    /**
     * O[h̑OɐeŃ[h邩ǂ
     * iorg.apache.loggingn͎O[hOɃ[hj
     * @param name
     * @return
     */
    private boolean preDelegateLoad(String name)
    {
    	if(name.startsWith("java."))
    		return true;
    	if(name.startsWith("javax."))
    		return true;
        if(name.startsWith("org.apache.commons.logging"))
            return true;
        if(name.startsWith("org.xml"))
        	return true;
        else
            return false;
    }
}
