package net.souko105.flashserver.javaee.imp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;

import org.apache.commons.collections.iterators.IteratorEnumeration;

/**
 * ServletContextNX
 * @author AKatayama
 */
public class ServletContextImp implements ServletContext
{
	private static final FlashServerLog log = FlashServerLogFactory.getLog(ServletConfigImp.class);
	
    private String servletContextName;//ReLXg /Ŏn܂ReLXgfBNg
    private String absoluteContextPath;//ReLXg܂ł̐΃pX
    
    private Map servletMap;
    private Map attributeMap = new HashMap();
    private Map initParamMap = new HashMap();
    
    ServletContextImp()
    {
        super();
    }
    public ServletContext getContext(String contextPath)
    {
    	WebApp webapp = WebAppManager.getInstance().findWebApp(contextPath);
    	if(webapp != null)
    		return webapp.getServletContext();
    	
        return null;
    }
    public Set getResourcePaths(String path)
    {
        if(path == null)
            return null;
        if(path.endsWith("/"))
            path = path.substring(0,path.length()-1);
        
        String absPath = absoluteContextPath + path;
        File targetResource = new File(absPath);
        if(targetResource.exists())
        {       
            Set set = new HashSet();
            if(targetResource.isDirectory())
            {
                File[] resources = targetResource.listFiles();
                if(resources != null)
                {
                    for(int i = 0;i < resources.length;i++)
                    {
                        File resource = resources[i];
                        String name = path + "/" + resource.getName();
                        if(resource.isDirectory())
                            name += "/";
                        set.add(name);
                    }
                }
            }
            else
            {
                String name = path + "/" + targetResource.getName();
                set.add(name);
            }
            if(!set.isEmpty())
            return set;    
        }
        return null;       
    }
    public URL getResource(String resource) throws MalformedURLException
    {
        return new URL("file",null,createResourcePath(resource));
    }
    public InputStream getResourceAsStream(String resource)
    {
        try
        {
            return new FileInputStream(createResourcePath(resource));
        }
        catch(Exception e)
        {
            return null;
        }
    }
    public Servlet getServlet(String name) throws ServletException
    {
    	if(servletMap == null)
    		return null;
        return (Servlet)servletMap.get(name);
    }
    public Enumeration getServlets()
    {
    	if(servletMap == null)
    		return new IteratorEnumeration();
        return new IteratorEnumeration(servletMap.values().iterator());
    }
    public Enumeration getServletNames()
    {
    	if(servletMap == null)
    		return new IteratorEnumeration();
        return new IteratorEnumeration(servletMap.keySet().iterator());
    }
    public String getRealPath(String resource)
    {
        return createResourcePath(resource);
    }
    public String getInitParameter(String key)
    {
        return (String)initParamMap.get(key);
    }
    public Enumeration getInitParameterNames()
    {
        return new IteratorEnumeration(initParamMap.keySet().iterator());
    }
    public Object getAttribute(String key)
    {
        return this.attributeMap.get(key);
    }
    public Enumeration getAttributeNames()
    {
        return new IteratorEnumeration(attributeMap.keySet().iterator());
    }
    public void setAttribute(String key, Object value)
    {
        this.attributeMap.put(key,value);
    }
    public void removeAttribute(String key)
    {
        this.attributeMap.remove(key);
    }
    public String getServletContextName()
    {
        return servletContextName;
    }
    public void log(String logValue)
    {
    	log.info(logValue);
    }
    public void log(Exception ex, String logValue)
    {
    	log.info(logValue,ex);
    }
    public void log(String logValue, Throwable t)
    {
    	log.info(logValue,t);
    }
    
    public int getMajorVersion()
    {
        return 0;
    }
    public int getMinorVersion()
    {
        return 0;
    }
    public String getMimeType(String arg0)
    {
        return null;
    }
    public RequestDispatcher getRequestDispatcher(String requestURI)
    {
    	try
    	{
    		WebApp webapp = WebAppManager.getInstance().findWebApp(this.servletContextName);
	    	Servlet servlet = webapp.findServlet(requestURI);
	    	RequestDispatcherImp rd = new RequestDispatcherImp(servlet,requestURI);
	        return rd;
    	}
    	catch(ServletException e)
    	{
    		return null;
    	}
    }
    public RequestDispatcher getNamedDispatcher(String arg0)
    {
        return null;
    }
    public String getServerInfo()
    {
        return null;
    }

    
    ///non interface method
    public void setServletMap(Map servletMap)
    {
        this.servletMap = servletMap;	
    }
    public void addInitParameter(String paramName,String paramValue)
    {
        this.initParamMap.put(paramName,paramValue);
    }    
    public void setServletContextName(String servletContextName)
    {
        this.servletContextName = servletContextName;
    }
    public void setAbsoluteContextPath(String absoluteContextPath)
    {
        this.absoluteContextPath = absoluteContextPath;
    }
    private String createResourcePath(String resource)
    {
        if(resource.startsWith("/") || resource.startsWith("\\"))
        {
            String path = absoluteContextPath + resource;
            return path;
        }
        else
        {
            String path = absoluteContextPath + "/" + resource;
            return path;
        }
    }
}
