package net.souko105.flashserver.javaee.imp;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
/**
 * FilterChainNX
 * @author AKatayama
 */
public class FilterChainImp implements FilterChain {

	private Filter[] nextFilters;
	private Servlet servlet;
	private int currentFilterNo = 0;
	
	public FilterChainImp(Filter[] nextFilter,Servlet servlet)
	{
		this.nextFilters = nextFilter;
		this.servlet = servlet;
	}
	public void doFilter(ServletRequest req, ServletResponse res)
			throws IOException, ServletException 
	{
		if(currentFilterNo < nextFilters.length)
			nextFilters[currentFilterNo++].doFilter(req,res,this);
		else
			servlet.service(req,res);
	}
}
