package net.souko105.flashserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * HTTPp[^
 * @author AKatayama
 */
public class HttpParameters
{
	public static final String DEFAULT_CHAR_ENCODE = "ISO-8859-1";
    private Map paramMap;
    private List paramNameList;
    private String characterEncoding = DEFAULT_CHAR_ENCODE;
    
    private HttpRequestBody body;
    
    public HttpParameters(HttpRequestBody body)
    {
        this.body = body;
    }
    private void init()
    {
    	if(paramMap == null)
    	{
	        paramMap = new HashMap();
	        paramNameList = new LinkedList();
	    	body.initParameters();
    	}
    }
    
    public String getParamter(String key)
    {
    	init();
    	
        List paramList = (List)paramMap.get(key);
        if(paramList == null)
            return null;
        
        String param = (String)paramList.get(0);
        return param;
    }
    public String[] getParamterValues(String key)
    {
    	init();
    	
        List paramList = (List)paramMap.get(key);
        if(paramList == null)
            return null;
        String[] params = (String[])paramList.toArray(new String[]{});
       	return params;
    }
    public Iterator getParameterNames()
    {
    	init();
    	
        return paramNameList.iterator();
    }
    public Map getParamterMap()
    {
    	init();
    	
        Map newMap = new HashMap();
        newMap.putAll(paramMap);
        return newMap;
    }
    public void setCharacterEncoding(String encoding)
    {
    	this.characterEncoding = encoding;
    }
    public String getCharacterEncodin()
    {
    	return characterEncoding;
    }
    
    void addParameter(String key,String value)
    {
        List paramList = (List)paramMap.get(key);
        if(paramList == null)
            paramList = new ArrayList();
        paramList.add(value);
        paramMap.put(key,paramList);
        paramNameList.add(key);
    }

}
