package net.souko105.flashserver;

import java.util.HashMap;
import java.util.Map;

/**
 * HTTPwb_[̒萔`
 * @author AKatayama
 */
public class HttpHeaderConst
{
    public static final String SESSIONID_KEY = "JSESSIONID";
    
    public static final String CACHECONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String DATE = "Date";
    public static final String PRAGMA = "Pragma";
    public static final String PROXYCONNECTION = "Proxy-Connection";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFERENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String ALLOW = "Allow";
    public static final String CONTENTENCODING = "Content-Encoding";
    public static final String CONTENTLANGUAGE = "Content-Language";
    public static final String CONTENTLENGTH = "Content-Length";
    public static final String CONTENTLOCATION = "Content-Location";
    public static final String CONTENTMD5 = "Content-MD5";
    public static final String CONTENTRANGE = "Content-Range";
    public static final String CONTENTTYPE = "Content-Type";
    public static final String EXPIRES = "Expires";
    public static final String LASTMODIFIED = "Last-Modified";
    /**
     * Request
     */
    public static final String ACCEPT = "Accept";
    public static final String ACCEPTCHARSET = "Accept-Charset";
    public static final String ACCEPTENCODING = "Accept-Encoding";
    public static final String ACCEPTLANGUAGE = "Accept-Language";
    public static final String AUTHORIZATION = "Authorization";
    public static final String EXPECT = "Expect";
    public static final String FORWARDED = "Forwarded";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IFMATCH = "If-Match";
    public static final String IFMODIFIEDSINCE = "If-Modified-Since";
    public static final String IFNONEMATCH = "If-None-Match";
    public static final String IFRANGE = "If-Range";
    public static final String IFUNMODIFIEDSINCE = "If-Unmodified-Since";
    public static final String KEEPALIVE = "Keep-Alive";
    public static final String MAXFORWARDS = "Max-Forwards";
    public static final String PROXYAUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REQUESTRANGE = "Request-Range";
    public static final String REFERER = "Referer";
    public static final String TE = "TE";
    public static final String USERAGENT = "User-Agent";
    public static final String XFORWARDEDFOR = "X-Forwarded-For";
    /**
     * Response
     */
    public static final String ACCEPTRANGES = "Accept-Ranges";
    public static final String AGE = "Age";
    public static final String ETAG = "ETag";
    public static final String LOCATION = "Location";
    public static final String PROXYAUTHENTICATE = "Proxy-Authenticate";
    public static final String RETRYAFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String SERVLETENGINE = "Servlet-Engine";
    public static final String VARY = "Vary";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String COOKIE = "Cookie";
    public static final String SETCOOKIE = "Set-Cookie";
    public static final String SETCOOKIE2 = "Set-Cookie2";
    public static final String MIMEVERSION = "MIME-Version";
    public static final String IDENTITY = "identity";
    public static final String SOAPACTION = "SOAPAction";
    /**
     * Field
     */
    public static final String CHUNKED = "chunked";
    public static final String CLOSE = "close";
    public static final String TEXTHTML = "text/html";
    public static final String MESSAGEHTTP = "message/http";
    public static final String WWW_FORM_URLENCODE = "application/x-www-form-urlencoded";
    public static final String EXPECTCONTINUE = "100-continue";
    /**
     * method
     */
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    public static final String OPTION = "OPTION";
    public static final String separators = ", \t";
    public static final char[] CRLF = { '\015', '\012' };
    public static final String CRLF_STRING = new String(CRLF);
    public static final char[] COLON = { ':', ' ' };
    public static final String COLON_STRING = new String(COLON);
    public static final char[] SEMI_COLON = { ';', ' ' };
    public static final String SEMI_COLON_STRING = new String(SEMI_COLON);
    
    public static final String[] DAYS = { "Sat", "Sun", "Mon", "Tue", "Wed", "Thu","Fri", "Sat" };
    public static final String[] MONTHS = { "Jan", "Feb", "Mar", "Apr", "May","Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan" };

    public static final String HTTP_1_1 = "HTTP/1.1";
    
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_FOUND = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;    
    
    private static Map statusMap;
    static
    {
        statusMap = new HashMap();
        statusMap.put(new Integer(100),"Continue");
        statusMap.put(new Integer(101),"Switching Protocols");
        statusMap.put(new Integer(200),"OK");
        statusMap.put(new Integer(201),"Created");
        statusMap.put(new Integer(202),"Accepted");
        statusMap.put(new Integer(203),"Non-Authoritative Information");
        statusMap.put(new Integer(204),"No Content");
        statusMap.put(new Integer(205),"Reset Content");
        statusMap.put(new Integer(206),"Partial Content");
        statusMap.put(new Integer(300),"Multiple Choices");
        statusMap.put(new Integer(301),"Moved Permanently");
        statusMap.put(new Integer(302),"Moved Temporarily");
        statusMap.put(new Integer(303),"See Other");
        statusMap.put(new Integer(304),"Not Modified");
        statusMap.put(new Integer(305),"Use Proxy");
        statusMap.put(new Integer(400),"Bad Request");
        statusMap.put(new Integer(401),"Unauthorized");
        statusMap.put(new Integer(402),"Payment Required");
        statusMap.put(new Integer(403),"Forbidden");
        statusMap.put(new Integer(404),"Not Found");
        statusMap.put(new Integer(405),"Method Not Allowed");
        statusMap.put(new Integer(406),"Not Acceptable");
        statusMap.put(new Integer(407),"Proxy Authentication Required");
        statusMap.put(new Integer(408),"Request Time-out");
        statusMap.put(new Integer(409),"Conflict");
        statusMap.put(new Integer(410),"Gone");
        statusMap.put(new Integer(411),"Length Required");
        statusMap.put(new Integer(412),"Precondition Failed");
        statusMap.put(new Integer(413),"Request Entity Too Large");
        statusMap.put(new Integer(414),"Request-URI Too Large");
        statusMap.put(new Integer(415),"Unsupported Media Type");
        statusMap.put(new Integer(500),"Internal Server Error");
        statusMap.put(new Integer(501),"Not Implemented");
        statusMap.put(new Integer(502),"Bad Gateway");
        statusMap.put(new Integer(503),"Service Unavailable");
        statusMap.put(new Integer(504),"Gateway Time-out");
        statusMap.put(new Integer(505),"HTTP Version not supported");
    }        
    public static String findStatus(int statusCode)
    {
        return (String)statusMap.get(new Integer(statusCode));
    }
    
    private HttpHeaderConst()
    {
        super();
    }

}
