/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.imp;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import net.souko105.flashserver.javaee.imp.HttpSessionImp;
import org.apache.commons.codec.binary.Base64;

public class SessionManager {
    private static SessionManager manager = new SessionManager();
    private Map sessionMap = new HashMap();
    private static long sessionIdSeed = System.currentTimeMillis() + (long)((int)Math.random() * 1000);
    private static final MessageDigest digest;

    static {
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private SessionManager() {
    }

    public static SessionManager getInstance() {
        return manager;
    }

    public HttpSession getSession(String sessionId, boolean createNew, ServletContext servletContext) {
        HttpSessionImp session = (HttpSessionImp)this.sessionMap.get(sessionId);
        if (session != null) {
            if (!session.isInvalidate()) {
                return session;
            }
            if (createNew) {
                return this.createNewSession(servletContext);
            }
            return null;
        }
        if (createNew) {
            return this.createNewSession(servletContext);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession createNewSession(ServletContext servletContext) {
        long sesIdSeed;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            sesIdSeed = ++sessionIdSeed;
        }
        byte[] digestId = digest.digest(Long.toString(sesIdSeed).getBytes());
        String sessionId = new String(Base64.encodeBase64((byte[])digestId));
        HttpSessionImp ses = new HttpSessionImp(sessionId);
        ses.setServletContext(servletContext);
        this.sessionMap.put(sessionId, ses);
        return ses;
    }
}

