/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import net.souko105.flashserver.HttpHeaderConst;

public class HttpResponseHeader {
    private String version = "HTTP/1.1";
    private int statusCode = 200;
    private String status = HttpHeaderConst.findStatus(200);
    private Map headerFieldMap = new HashMap();
    private List headerFieldNameList = new LinkedList();
    private Map cookieMap = new HashMap();
    private List cookieNameList = new LinkedList();

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookieMap.containsKey(cookie.getName())) {
            this.cookieNameList.add(cookie.getName());
        }
        this.cookieMap.put(cookie.getName(), cookie);
    }

    public String getHeader(String paramName) {
        return (String)this.headerFieldMap.get(paramName);
    }

    public void addHeader(String name, String value) {
        if (!this.headerFieldMap.containsKey(name)) {
            this.headerFieldNameList.add(name);
        }
        this.headerFieldMap.put(name, value);
    }

    public List getHeaderName() {
        return this.headerFieldNameList;
    }

    public List getHeaders() {
        ArrayList list = new ArrayList();
        Iterator itr = this.headerFieldNameList.iterator();
        while (itr.hasNext()) {
            list.add(this.headerFieldMap.get(itr.next()));
        }
        return list;
    }

    public void removeHeader(String paramName) {
        this.headerFieldMap.remove(paramName);
        this.headerFieldNameList.remove(paramName);
    }

    public boolean containsHeader(String name) {
        return this.headerFieldMap.get(name) != null;
    }

    public String getHeaderString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.version) + " " + this.statusCode + " " + this.status + HttpHeaderConst.CRLF_STRING);
        Iterator itr = this.headerFieldNameList.iterator();
        while (itr.hasNext()) {
            String headerName = (String)itr.next();
            String headerValue = (String)this.headerFieldMap.get(headerName);
            buf.append(String.valueOf(headerName) + HttpHeaderConst.COLON_STRING + headerValue + HttpHeaderConst.CRLF_STRING);
        }
        itr = this.cookieNameList.iterator();
        while (itr.hasNext()) {
            String cookieName = (String)itr.next();
            Cookie cookie = (Cookie)this.cookieMap.get(cookieName);
            buf.append("Set-Cookie" + HttpHeaderConst.COLON_STRING);
            buf.append(String.valueOf(cookie.getName()) + "=" + cookie.getValue() + HttpHeaderConst.SEMI_COLON_STRING);
            buf.append(HttpHeaderConst.CRLF_STRING);
        }
        return buf.toString();
    }
}

