/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.asm;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import sun.tools.asm.CatchData;
import sun.tools.asm.ConstantPool;
import sun.tools.asm.Cover;
import sun.tools.asm.Instruction;
import sun.tools.asm.Label;
import sun.tools.asm.LocalVariable;
import sun.tools.asm.LocalVariableTable;
import sun.tools.asm.SwitchData;
import sun.tools.asm.TryData;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.javac.SourceClass;

public final class Assembler
implements Constants {
    static final int NOTREACHED = 0;
    static final int REACHED = 1;
    static final int NEEDED = 2;
    Label first = new Label();
    Instruction last = this.first;
    int maxdepth;
    int maxvar;
    int maxpc;
    static Vector SourceClassList = new Vector();
    static Vector TmpCovTable = new Vector();
    static int[] JcovClassCountArray = new int[9];
    static String JcovMagicLine = "JCOV-DATA-FILE-VERSION: 2.0";
    static String JcovClassLine = "CLASS: ";
    static String JcovSrcfileLine = "SRCFILE: ";
    static String JcovTimestampLine = "TIMESTAMP: ";
    static String JcovDataLine = "DATA: ";
    static String JcovHeadingLine = "#kind\tcount";
    static int[] arrayModifiers = new int[]{1, 2, 4, 1024, 16, 512};
    static int[] arrayModifiersOpc = new int[]{121, 120, 122, 130, 128, 114};

    boolean eliminate() {
        boolean bl = false;
        Instruction instruction = this.first;
        Instruction instruction2 = this.first.next;
        while (instruction2 != null) {
            if (instruction2.pc != 0) {
                instruction.next = instruction2;
                instruction = instruction2;
                instruction2.pc = 0;
            } else {
                bl = true;
            }
            instruction2 = instruction2.next;
        }
        this.first.pc = 0;
        instruction.next = null;
        return bl;
    }

    public boolean empty() {
        return this.first == this.last;
    }

    public void add(long l, int n) {
        this.add(new Instruction(l, n, null));
    }

    public void add(long l, int n, boolean bl) {
        this.add(new Instruction(l, n, bl));
    }

    public void listing(PrintStream printStream) {
        printStream.println("-- listing --");
        Instruction instruction = this.first;
        while (instruction != null) {
            printStream.println(((Instruction)instruction).toString());
            instruction = instruction.next;
        }
    }

    public void add(long l, int n, Object object) {
        this.add(new Instruction(l, n, object));
    }

    public void add(long l, int n, Object object, boolean bl) {
        this.add(new Instruction(l, n, object, bl));
    }

    public void add(boolean bl, long l, int n, Object object) {
        this.add(new Instruction(bl, l, n, object));
    }

    public void add(Instruction instruction) {
        if (instruction != null) {
            this.last.next = instruction;
            this.last = instruction;
        }
    }

    void balance(Label label, int n) {
        Instruction instruction = label;
        while (instruction != null) {
            if ((n += instruction.balance()) < 0) {
                throw new CompilerError("stack under flow: " + instruction.toString() + " = " + n);
            }
            if (n > this.maxdepth) {
                this.maxdepth = n;
            }
            switch (instruction.opc) {
                case -1: {
                    label = instruction;
                    if (instruction.pc == 1) {
                        if (label.depth != n) {
                            throw new CompilerError("stack depth error " + n + "/" + label.depth + ": " + instruction.toString());
                        }
                        return;
                    }
                    label.pc = 1;
                    label.depth = n;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.balance((Label)instruction.value, n);
                    break;
                }
                case 167: {
                    this.balance((Label)instruction.value, n);
                    return;
                }
                case 168: {
                    this.balance((Label)instruction.value, n + 1);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    int n2 = (instruction.value instanceof Number ? ((Number)instruction.value).intValue() : ((LocalVariable)instruction.value).slot) + 1;
                    if (n2 <= this.maxvar) break;
                    this.maxvar = n2;
                    break;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    int n3 = (instruction.value instanceof Number ? ((Number)instruction.value).intValue() : ((LocalVariable)instruction.value).slot) + 2;
                    if (n3 <= this.maxvar) break;
                    this.maxvar = n3;
                    break;
                }
                case 132: {
                    int n4 = ((int[])instruction.value)[0] + 1;
                    if (n4 <= this.maxvar) break;
                    this.maxvar = n4 + 1;
                    break;
                }
                case 170: 
                case 171: {
                    SwitchData switchData = (SwitchData)instruction.value;
                    this.balance(switchData.defaultLabel, n);
                    Enumeration<Object> enumeration = switchData.tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.balance((Label)enumeration.nextElement(), n);
                    }
                    return;
                }
                case -3: {
                    TryData tryData = (TryData)instruction.value;
                    Enumeration<Object> enumeration = tryData.catches.elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.balance(catchData.getLabel(), n + 1);
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    public void GenJCov(Environment environment) {
        try {
            Object object;
            Closeable closeable;
            File file = environment.getcovFile();
            if (file.exists()) {
                closeable = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                object = null;
                boolean bl = true;
                object = ((DataInputStream)closeable).readLine();
                if (object != null && ((String)object).startsWith(JcovMagicLine)) {
                    while ((object = ((DataInputStream)closeable).readLine()) != null) {
                        if (((String)object).startsWith(JcovClassLine)) {
                            bl = true;
                            Enumeration enumeration = SourceClassList.elements();
                            while (enumeration.hasMoreElements()) {
                                String string;
                                String string2 = ((String)object).substring(JcovClassLine.length());
                                int n = string2.indexOf(32);
                                if (n != -1) {
                                    string2 = string2.substring(0, n);
                                }
                                if ((string = (String)enumeration.nextElement()).compareTo(string2) != 0) continue;
                                bl = false;
                                break;
                            }
                        }
                        if (!bl) continue;
                        TmpCovTable.addElement(object);
                    }
                }
                ((FilterInputStream)closeable).close();
            }
            closeable = new PrintStream(new DataOutputStream(new FileOutputStream(file)));
            ((PrintStream)closeable).println(JcovMagicLine);
            object = TmpCovTable.elements();
            while (object.hasMoreElements()) {
                ((PrintStream)closeable).println(object.nextElement());
            }
            ((PrintStream)closeable).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("ERROR: " + iOException);
        }
    }

    public void optimize(Environment environment) {
        do {
            this.optimize(environment, this.first);
        } while (this.eliminate() && environment.opt());
    }

    void optimize(Environment environment, Label label) {
        label.pc = 1;
        Instruction instruction = label.next;
        while (instruction != null) {
            switch (instruction.pc) {
                case 0: {
                    instruction.optimize(environment);
                    instruction.pc = 1;
                    break;
                }
                case 1: {
                    return;
                }
            }
            switch (instruction.opc) {
                case -2: 
                case -1: {
                    if (instruction.pc != 1) break;
                    instruction.pc = 0;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.optimize(environment, (Label)instruction.value);
                    break;
                }
                case 167: {
                    this.optimize(environment, (Label)instruction.value);
                    return;
                }
                case 168: {
                    this.optimize(environment, (Label)instruction.value);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 170: 
                case 171: {
                    Object object = (SwitchData)instruction.value;
                    this.optimize(environment, ((SwitchData)object).defaultLabel);
                    Enumeration<Object> enumeration = ((SwitchData)object).tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.optimize(environment, (Label)enumeration.nextElement());
                    }
                    return;
                }
                case -3: {
                    Object object = (TryData)instruction.value;
                    ((TryData)object).getEndLabel().pc = 2;
                    Enumeration<Object> enumeration = ((TryData)object).catches.elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.optimize(environment, catchData.getLabel());
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    public void addNativeToJcovTab(Environment environment, ClassDefinition classDefinition) {
        JcovClassCountArray[1] = JcovClassCountArray[1] + 1;
    }

    public void GenVecJCov(Environment environment, ClassDefinition classDefinition, long l) {
        String string = ((SourceClass)classDefinition).getAbsoluteName();
        TmpCovTable.addElement(this.createClassJcovElement(environment, classDefinition));
        TmpCovTable.addElement(JcovSrcfileLine + string);
        TmpCovTable.addElement(JcovTimestampLine + l);
        TmpCovTable.addElement(JcovDataLine + "A");
        TmpCovTable.addElement(JcovHeadingLine);
        for (int i = 1; i <= 8; ++i) {
            if (JcovClassCountArray[i] == 0) continue;
            TmpCovTable.addElement(new String(i + "\t" + JcovClassCountArray[i]));
            Assembler.JcovClassCountArray[i] = 0;
        }
    }

    private String createClassJcovElement(Environment environment, ClassDefinition classDefinition) {
        String string = Type.mangleInnerType(classDefinition.getClassDeclaration().getName()).toString();
        SourceClassList.addElement(string);
        String string2 = string.replace('.', '/');
        String string3 = JcovClassLine + string2;
        string3 = string3 + " [";
        String string4 = "";
        for (int i = 0; i < arrayModifiers.length; ++i) {
            if ((classDefinition.getModifiers() & arrayModifiers[i]) == 0) continue;
            string3 = string3 + string4 + opNames[arrayModifiersOpc[i]];
            string4 = " ";
        }
        string3 = string3 + "]";
        return string3;
    }

    public void writeLineNumberTable(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        long l;
        long l2 = -1L;
        int n = 0;
        Instruction instruction = this.first;
        while (instruction != null) {
            l = instruction.where >> 32;
            if (l > 0L && l2 != l) {
                l2 = l;
                ++n;
            }
            instruction = instruction.next;
        }
        l2 = -1L;
        dataOutputStream.writeShort(n);
        instruction = this.first;
        while (instruction != null) {
            l = instruction.where >> 32;
            if (l > 0L && l2 != l) {
                l2 = l;
                dataOutputStream.writeShort(instruction.pc);
                dataOutputStream.writeShort((int)l2);
            }
            instruction = instruction.next;
        }
    }

    public void collect(Environment environment, MemberDefinition memberDefinition, ConstantPool constantPool) {
        Object object;
        if (memberDefinition != null && environment.debug_vars() && memberDefinition.getArguments() != null) {
            object = memberDefinition.getArguments().elements();
            while (object.hasMoreElements()) {
                MemberDefinition memberDefinition2 = (MemberDefinition)object.nextElement();
                constantPool.put(memberDefinition2.getName().toString());
                constantPool.put(memberDefinition2.getType().getTypeSignature());
            }
        }
        object = this.first;
        while (object != null) {
            ((Instruction)object).collect(constantPool);
            object = ((Instruction)object).next;
        }
    }

    void flowFields(Environment environment, Label label, MemberDefinition[] memberDefinitionArray) {
        if (label.locals != null) {
            MemberDefinition[] memberDefinitionArray2 = label.locals;
            for (int i = 0; i < this.maxvar; ++i) {
                if (memberDefinitionArray2[i] == memberDefinitionArray[i]) continue;
                memberDefinitionArray2[i] = null;
            }
            return;
        }
        label.locals = new MemberDefinition[this.maxvar];
        System.arraycopy(memberDefinitionArray, 0, label.locals, 0, this.maxvar);
        MemberDefinition[] memberDefinitionArray3 = new MemberDefinition[this.maxvar];
        System.arraycopy(memberDefinitionArray, 0, memberDefinitionArray3, 0, this.maxvar);
        memberDefinitionArray = memberDefinitionArray3;
        Instruction instruction = label.next;
        while (instruction != null) {
            switch (instruction.opc) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (!(instruction.value instanceof LocalVariable)) break;
                    Object object = (LocalVariable)instruction.value;
                    memberDefinitionArray[((LocalVariable)object).slot] = ((LocalVariable)object).field;
                    break;
                }
                case -1: {
                    this.flowFields(environment, (Label)instruction, memberDefinitionArray);
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 168: 
                case 198: 
                case 199: {
                    this.flowFields(environment, (Label)instruction.value, memberDefinitionArray);
                    break;
                }
                case 167: {
                    this.flowFields(environment, (Label)instruction.value, memberDefinitionArray);
                    return;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 170: 
                case 171: {
                    Object object = (SwitchData)instruction.value;
                    this.flowFields(environment, ((SwitchData)object).defaultLabel, memberDefinitionArray);
                    Enumeration<Object> enumeration = ((SwitchData)object).tab.elements();
                    while (enumeration.hasMoreElements()) {
                        this.flowFields(environment, (Label)enumeration.nextElement(), memberDefinitionArray);
                    }
                    return;
                }
                case -3: {
                    Object object = ((TryData)instruction.value).catches;
                    Enumeration<Object> enumeration = ((Vector)object).elements();
                    while (enumeration.hasMoreElements()) {
                        CatchData catchData = (CatchData)enumeration.nextElement();
                        this.flowFields(environment, catchData.getLabel(), memberDefinitionArray);
                    }
                    break;
                }
            }
            instruction = instruction.next;
        }
    }

    public void writeCoverageTable(Environment environment, ClassDefinition classDefinition, DataOutputStream dataOutputStream, ConstantPool constantPool, long l) throws IOException {
        long l2;
        Vector<Cover> vector = new Vector<Cover>();
        boolean bl = false;
        boolean bl2 = false;
        long l3 = ((SourceClass)classDefinition).getWhere();
        Vector<Long> vector2 = new Vector<Long>();
        boolean bl3 = false;
        int n = 0;
        Object object = this.first;
        while (object != null) {
            Enumeration enumeration;
            l2 = ((Instruction)object).where >> 32;
            if (l2 > 0L && ((Instruction)object).opc != -1) {
                if (!bl2) {
                    if (l3 == ((Instruction)object).where) {
                        vector.addElement(new Cover(2, l, ((Instruction)object).pc));
                    } else {
                        vector.addElement(new Cover(1, l, ((Instruction)object).pc));
                    }
                    ++n;
                    bl2 = true;
                }
                if (!bl && !((Instruction)object).flagNoCovered) {
                    boolean bl4 = false;
                    enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        if ((Long)enumeration.nextElement() != ((Instruction)object).where) continue;
                        bl4 = true;
                        break;
                    }
                    if (!bl4) {
                        vector.addElement(new Cover(3, ((Instruction)object).where, ((Instruction)object).pc));
                        ++n;
                        bl = true;
                    }
                }
            }
            switch (((Instruction)object).opc) {
                case -1: {
                    bl = false;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    if (((Instruction)object).flagCondInverted) {
                        vector.addElement(new Cover(7, ((Instruction)object).where, ((Instruction)object).pc));
                        vector.addElement(new Cover(8, ((Instruction)object).where, ((Instruction)object).pc));
                    } else {
                        vector.addElement(new Cover(8, ((Instruction)object).where, ((Instruction)object).pc));
                        vector.addElement(new Cover(7, ((Instruction)object).where, ((Instruction)object).pc));
                    }
                    n += 2;
                    bl = false;
                    break;
                }
                case 167: {
                    bl = false;
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    break;
                }
                case -3: {
                    vector2.addElement(new Long(((Instruction)object).where));
                    bl = false;
                    break;
                }
                case 170: {
                    SwitchData switchData = (SwitchData)((Instruction)object).value;
                    for (int i = switchData.minValue; i <= switchData.maxValue; ++i) {
                        vector.addElement(new Cover(5, switchData.whereCase(new Integer(i)), ((Instruction)object).pc));
                        ++n;
                    }
                    if (!switchData.getDefault()) {
                        vector.addElement(new Cover(6, ((Instruction)object).where, ((Instruction)object).pc));
                        ++n;
                    } else {
                        vector.addElement(new Cover(5, switchData.whereCase("default"), ((Instruction)object).pc));
                        ++n;
                    }
                    bl = false;
                    break;
                }
                case 171: {
                    SwitchData switchData = (SwitchData)((Instruction)object).value;
                    enumeration = switchData.sortedKeys();
                    while (enumeration.hasMoreElements()) {
                        Integer n2 = (Integer)enumeration.nextElement();
                        vector.addElement(new Cover(5, switchData.whereCase(n2), ((Instruction)object).pc));
                        ++n;
                    }
                    if (!switchData.getDefault()) {
                        vector.addElement(new Cover(6, ((Instruction)object).where, ((Instruction)object).pc));
                        ++n;
                    } else {
                        vector.addElement(new Cover(5, switchData.whereCase("default"), ((Instruction)object).pc));
                        ++n;
                    }
                    bl = false;
                }
            }
            object = ((Instruction)object).next;
        }
        dataOutputStream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            object = (Cover)vector.elementAt(i);
            l2 = ((Cover)object).Addr >> 32;
            long l4 = ((Cover)object).Addr << 32 >> 32;
            dataOutputStream.writeShort(((Cover)object).NumCommand);
            dataOutputStream.writeShort(((Cover)object).Type);
            dataOutputStream.writeInt((int)l2);
            dataOutputStream.writeInt((int)l4);
            if (((Cover)object).Type == 5 && ((Cover)object).Addr == 0L) continue;
            int n3 = ((Cover)object).Type;
            JcovClassCountArray[n3] = JcovClassCountArray[n3] + 1;
        }
    }

    public void writeLocalVariableTable(Environment environment, MemberDefinition memberDefinition, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        Object object;
        Object object2;
        Object object3;
        MemberDefinition[] memberDefinitionArray = new MemberDefinition[this.maxvar];
        int n = 0;
        if (memberDefinition != null && memberDefinition.getArguments() != null) {
            int n2 = 0;
            object3 = memberDefinition.getArguments();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (MemberDefinition)object2.nextElement();
                memberDefinitionArray[n2] = object;
                n2 += ((MemberDefinition)object).getType().stackSize();
            }
        }
        this.flowFields(environment, this.first, memberDefinitionArray);
        LocalVariableTable localVariableTable = new LocalVariableTable();
        for (n = 0; n < this.maxvar; ++n) {
            memberDefinitionArray[n] = null;
        }
        if (memberDefinition != null && memberDefinition.getArguments() != null) {
            int n3 = 0;
            object2 = memberDefinition.getArguments();
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                MemberDefinition memberDefinition2;
                memberDefinitionArray[n3] = memberDefinition2 = (MemberDefinition)object.nextElement();
                localVariableTable.define(memberDefinition2, n3, 0, this.maxpc);
                n3 += memberDefinition2.getType().stackSize();
            }
        }
        object3 = new int[this.maxvar];
        object2 = this.first;
        while (object2 != null) {
            switch (((Instruction)object2).opc) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int n4;
                    if (!(((Instruction)object2).value instanceof LocalVariable)) break;
                    LocalVariable localVariable = (LocalVariable)((Instruction)object2).value;
                    int n5 = n4 = ((Instruction)object2).next != null ? ((Instruction)object2).next.pc : ((Instruction)object2).pc;
                    if (memberDefinitionArray[localVariable.slot] != null) {
                        localVariableTable.define(memberDefinitionArray[localVariable.slot], localVariable.slot, (int)object3[localVariable.slot], n4);
                    }
                    object3[localVariable.slot] = n4;
                    memberDefinitionArray[localVariable.slot] = localVariable.field;
                    break;
                }
                case -1: {
                    for (n = 0; n < this.maxvar; ++n) {
                        if (memberDefinitionArray[n] == null) continue;
                        localVariableTable.define(memberDefinitionArray[n], n, (int)object3[n], ((Instruction)object2).pc);
                    }
                    int n6 = ((Instruction)object2).pc;
                    MemberDefinition[] memberDefinitionArray2 = ((Label)object2).locals;
                    if (memberDefinitionArray2 == null) {
                        for (n = 0; n < this.maxvar; ++n) {
                            memberDefinitionArray[n] = null;
                        }
                    } else {
                        System.arraycopy(memberDefinitionArray2, 0, memberDefinitionArray, 0, this.maxvar);
                    }
                    for (n = 0; n < this.maxvar; ++n) {
                        object3[n] = n6;
                    }
                    break;
                }
            }
            object2 = ((Instruction)object2).next;
        }
        for (n = 0; n < this.maxvar; ++n) {
            if (memberDefinitionArray[n] == null) continue;
            localVariableTable.define(memberDefinitionArray[n], n, (int)object3[n], this.maxpc);
        }
        localVariableTable.write(environment, dataOutputStream, constantPool);
    }

    public void write(Environment environment, DataOutputStream dataOutputStream, MemberDefinition memberDefinition, ConstantPool constantPool) throws IOException {
        Object object;
        int n;
        if (memberDefinition != null && memberDefinition.getArguments() != null) {
            n = 0;
            Vector vector = memberDefinition.getArguments();
            object = vector.elements();
            while (object.hasMoreElements()) {
                MemberDefinition memberDefinition2 = (MemberDefinition)object.nextElement();
                n += memberDefinition2.getType().stackSize();
            }
            this.maxvar = n;
        }
        try {
            this.balance(this.first, 0);
        }
        catch (CompilerError compilerError) {
            System.out.println("ERROR: " + compilerError);
            this.listing(System.out);
            throw compilerError;
        }
        n = 0;
        int n2 = 0;
        object = this.first;
        while (object != null) {
            ((Instruction)object).pc = n;
            int n3 = ((Instruction)object).size(constantPool);
            if (n < 65536 && n + n3 >= 65536) {
                environment.error(((Instruction)object).where, "warn.method.too.long");
            }
            n += n3;
            if (((Instruction)object).opc == -3) {
                n2 += ((TryData)((Instruction)object).value).catches.size();
            }
            object = ((Instruction)object).next;
        }
        dataOutputStream.writeShort(this.maxdepth);
        dataOutputStream.writeShort(this.maxvar);
        this.maxpc = n;
        dataOutputStream.writeInt(this.maxpc);
        object = this.first.next;
        while (object != null) {
            ((Instruction)object).write(dataOutputStream, constantPool);
            object = ((Instruction)object).next;
        }
        dataOutputStream.writeShort(n2);
        if (n2 > 0) {
            this.writeExceptions(environment, dataOutputStream, constantPool, this.first, this.last);
        }
    }

    void writeExceptions(Environment environment, DataOutputStream dataOutputStream, ConstantPool constantPool, Instruction instruction, Instruction instruction2) throws IOException {
        Instruction instruction3 = instruction;
        while (instruction3 != instruction2.next) {
            if (instruction3.opc == -3) {
                TryData tryData = (TryData)instruction3.value;
                this.writeExceptions(environment, dataOutputStream, constantPool, instruction3.next, tryData.getEndLabel());
                Enumeration enumeration = tryData.catches.elements();
                while (enumeration.hasMoreElements()) {
                    CatchData catchData = (CatchData)enumeration.nextElement();
                    dataOutputStream.writeShort(instruction3.pc);
                    dataOutputStream.writeShort(tryData.getEndLabel().pc);
                    dataOutputStream.writeShort(catchData.getLabel().pc);
                    if (catchData.getType() != null) {
                        dataOutputStream.writeShort(constantPool.index(catchData.getType()));
                        continue;
                    }
                    dataOutputStream.writeShort(0);
                }
                instruction3 = tryData.getEndLabel();
            }
            instruction3 = instruction3.next;
        }
    }
}

