/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ThreadGroupReferenceImpl
extends ObjectReferenceImpl
implements ThreadGroupReference,
VMListener {
    String name;
    ThreadGroupReference parent;
    boolean triedParent;

    byte typeValueKey() {
        return 103;
    }

    public void resume() {
        List list = this.threads();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ThreadReference)iterator.next()).resume();
        }
        List list2 = this.threadGroups();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((ThreadGroupReference)iterator.next()).resume();
        }
    }

    public void suspend() {
        List list = this.threads();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ThreadReference)iterator.next()).suspend();
        }
        List list2 = this.threadGroups();
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((ThreadGroupReference)iterator.next()).suspend();
        }
    }

    public ThreadGroupReference parent() {
        if (!this.triedParent) {
            try {
                this.parent = JDWP.ThreadGroupReference.Parent.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).parentGroup;
                this.triedParent = true;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.parent;
    }

    ThreadGroupReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.vm.state().addListener(this);
    }

    private JDWP.ThreadGroupReference.Children kids() {
        JDWP.ThreadGroupReference.Children children = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                children = cache.kids;
            }
            if (children == null) {
                children = JDWP.ThreadGroupReference.Children.process(this.vm, this);
                if (cache != null) {
                    cache.kids = children;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching children ");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return children;
    }

    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    protected String description() {
        return "ThreadGroupReference " + this.uniqueID();
    }

    public String name() {
        if (this.name == null) {
            try {
                this.name = JDWP.ThreadGroupReference.Name.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).groupName;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.name;
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }

    public List threadGroups() {
        return Arrays.asList(this.kids().childGroups);
    }

    public List threads() {
        return Arrays.asList(this.kids().childThreads);
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        JDWP.ThreadGroupReference.Children kids = null;

        private Cache() {
        }
    }
}

