/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.javah.Gen;
import com.sun.tools.javah.Mangle;
import com.sun.tools.javah.TypeSignature;
import com.sun.tools.javah.Util;
import java.io.OutputStream;
import java.io.PrintWriter;

public class JNI
extends Gen {
    public JNI(RootDoc rootDoc) {
        super(rootDoc);
    }

    public String getIncludes() {
        return "#include <jni.h>";
    }

    public void write(OutputStream outputStream, ClassDoc classDoc) throws ClassNotFoundException {
        String string = Mangle.mangle(classDoc.qualifiedName(), 1);
        PrintWriter printWriter = this.wrapWriter(outputStream);
        printWriter.println(this.guardBegin(string));
        printWriter.println(this.cppGuardBegin());
        FieldDoc[] fieldDocArray = classDoc.fields();
        for (int i = 0; i < fieldDocArray.length; ++i) {
            if (!fieldDocArray[i].isStatic()) continue;
            String string2 = null;
            string2 = this.defineForStatic(classDoc, fieldDocArray[i]);
            if (string2 == null) continue;
            printWriter.println(string2);
        }
        MethodDoc[] methodDocArray = classDoc.methods();
        for (int i = 0; i < methodDocArray.length; ++i) {
            int n;
            if (!methodDocArray[i].isNative()) continue;
            MethodDoc methodDoc = methodDocArray[i];
            Type type = methodDocArray[i].returnType();
            String string3 = methodDoc.signature();
            TypeSignature typeSignature = new TypeSignature(this.root);
            String string4 = methodDoc.name();
            boolean bl = false;
            for (int j = 0; j < methodDocArray.length; ++j) {
                if (methodDocArray[j] == methodDoc || !string4.equals(methodDocArray[j].name()) || !methodDocArray[j].isNative()) continue;
                bl = true;
            }
            printWriter.println("/*");
            printWriter.println(" * Class:     " + string);
            printWriter.println(" * Method:    " + Mangle.mangle(string4, 2));
            printWriter.println(" * Signature: " + typeSignature.getTypeSignature(string3, type));
            printWriter.println(" */");
            printWriter.println("JNIEXPORT " + this.jniType(type) + " JNICALL " + Mangle.mangleMethod(methodDoc, this.root, classDoc, bl ? 8 : 7));
            printWriter.print("  (JNIEnv *, ");
            Parameter[] parameterArray = methodDoc.parameters();
            Type[] typeArray = new Type[parameterArray.length];
            for (n = 0; n < parameterArray.length; ++n) {
                typeArray[n] = parameterArray[n].type();
            }
            if (methodDoc.isStatic()) {
                printWriter.print("jclass");
            } else {
                printWriter.print("jobject");
            }
            if (typeArray.length > 0) {
                printWriter.print(", ");
            }
            for (n = 0; n < typeArray.length; ++n) {
                printWriter.print(this.jniType(typeArray[n]));
                if (n == typeArray.length - 1) continue;
                printWriter.print(", ");
            }
            printWriter.println(");\n");
        }
        printWriter.println(this.cppGuardEnd());
        printWriter.println(this.guardEnd(string));
    }

    protected final String jniType(Type type) {
        String string = type.typeName();
        ClassDoc classDoc = this.root.classNamed("java.lang.Throwable");
        ClassDoc classDoc2 = this.root.classNamed("java.lang.Class");
        ClassDoc classDoc3 = type.asClassDoc();
        if (type.dimension().indexOf("[]") != -1) {
            if (type.dimension().indexOf("[][]") != -1 || classDoc3 != null) {
                return "jobjectArray";
            }
            if (string.equals("boolean")) {
                return "jbooleanArray";
            }
            if (string.equals("byte")) {
                return "jbyteArray";
            }
            if (string.equals("char")) {
                return "jcharArray";
            }
            if (string.equals("short")) {
                return "jshortArray";
            }
            if (string.equals("int")) {
                return "jintArray";
            }
            if (string.equals("long")) {
                return "jlongArray";
            }
            if (string.equals("float")) {
                return "jfloatArray";
            }
            if (string.equals("double")) {
                return "jdoubleArray";
            }
        } else {
            if (string.equals("void")) {
                return "void";
            }
            if (string.equals("String")) {
                return "jstring";
            }
            if (string.equals("boolean")) {
                return "jboolean";
            }
            if (string.equals("byte")) {
                return "jbyte";
            }
            if (string.equals("char")) {
                return "jchar";
            }
            if (string.equals("short")) {
                return "jshort";
            }
            if (string.equals("int")) {
                return "jint";
            }
            if (string.equals("long")) {
                return "jlong";
            }
            if (string.equals("float")) {
                return "jfloat";
            }
            if (string.equals("double")) {
                return "jdouble";
            }
            if (classDoc3 != null) {
                if (classDoc3.subclassOf(classDoc)) {
                    return "jthrowable";
                }
                if (classDoc3.subclassOf(classDoc2)) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        Util.bug("jni.unknown.type");
        return null;
    }
}

