/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.comp;

import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Kinds;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symtab;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.code.TypeTags;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeInfo;
import com.sun.tools.javac.v8.tree.TreeMaker;
import com.sun.tools.javac.v8.tree.TreeTranslator;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Name;

public class TransTypes
extends TreeTranslator
implements Flags,
Kinds,
TypeTags {
    private static final Context.Key transTypesKey = new Context.Key();
    private Name.Table names;
    private Log log;
    private Symtab syms;
    private TreeMaker make;
    Hashtable overridden;
    private Type pt;

    public void visitApply(Tree.Apply apply) {
        apply.meth = this.translate(apply.meth, null);
        Type type = TreeInfo.symbol(apply.meth).erasure();
        apply.args = this.translateArgs(apply.args, type.argtypes());
        this.result = this.retype(apply, type.restype(), this.pt);
    }

    public void visitAssert(Tree.Assert assert_) {
        assert_.cond = this.translate(assert_.cond, null);
        if (assert_.detail != null) {
            assert_.detail = this.translate(assert_.detail, null);
        }
        this.result = assert_;
    }

    public void visitAssign(Tree.Assign assign) {
        assign.lhs = this.translate(assign.lhs, null);
        assign.rhs = this.translate(assign.rhs, assign.lhs.type.erasure());
        assign.type = assign.type.erasure();
        this.result = assign;
    }

    public void visitAssignop(Tree.Assignop assignop) {
        assignop.lhs = this.translate(assignop.lhs, null);
        assignop.rhs = this.translate(assignop.rhs, null);
        assignop.type = assignop.type.erasure();
        this.result = assignop;
    }

    public void visitBinary(Tree.Binary binary) {
        binary.lhs = this.translate(binary.lhs, (Type)binary.operator.type.argtypes().head);
        binary.rhs = this.translate(binary.rhs, (Type)binary.operator.type.argtypes().tail.head);
        this.result = binary;
    }

    public void visitCase(Tree.Case case_) {
        case_.pat = this.translate(case_.pat, null);
        case_.stats = this.translate(case_.stats);
        this.result = case_;
    }

    public void visitClassDef(Tree.ClassDef classDef) {
        classDef.typarams = Tree.TypeParameter.emptyList;
        super.visitClassDef(classDef);
        this.make.at(classDef.pos);
        classDef.type = classDef.type.erasure();
        this.result = classDef;
    }

    public void visitConditional(Tree.Conditional conditional) {
        conditional.cond = this.translate(conditional.cond, null);
        conditional.truepart = this.translate(conditional.truepart, conditional.type.erasure());
        conditional.falsepart = this.translate(conditional.falsepart, conditional.type.erasure());
        this.result = conditional;
    }

    public void visitDoLoop(Tree.DoLoop doLoop) {
        doLoop.body = this.translate(doLoop.body);
        doLoop.cond = this.translate(doLoop.cond, null);
        this.result = doLoop;
    }

    public void visitExec(Tree.Exec exec) {
        exec.expr = this.translate(exec.expr, null);
        this.result = exec;
    }

    public void visitForLoop(Tree.ForLoop forLoop) {
        forLoop.init = this.translate(forLoop.init, null);
        forLoop.cond = this.translate(forLoop.cond, null);
        forLoop.step = this.translate(forLoop.step, null);
        forLoop.body = this.translate(forLoop.body);
        this.result = forLoop;
    }

    public void visitIdent(Tree.Ident ident) {
        Type type = ident.sym.erasure();
        if (ident.type.constValue != null) {
            this.result = ident;
        } else if (ident.sym.kind == 4) {
            this.result = this.retype(ident, type, this.pt);
        } else {
            ident.type = ident.type.erasure();
            this.result = ident;
        }
    }

    public void visitIf(Tree.If if_) {
        if_.cond = this.translate(if_.cond, null);
        if_.thenpart = this.translate(if_.thenpart);
        if_.elsepart = this.translate(if_.elsepart);
        this.result = if_;
    }

    public void visitIndexed(Tree.Indexed indexed) {
        indexed.indexed = this.translate(indexed.indexed, indexed.indexed.type.erasure());
        indexed.index = this.translate(indexed.index, null);
        this.result = this.retype(indexed, indexed.indexed.type.elemtype(), this.pt);
    }

    public void visitMethodDef(Tree.MethodDef methodDef) {
        methodDef.restype = this.translate(methodDef.restype, null);
        methodDef.typarams = Tree.TypeParameter.emptyList;
        methodDef.params = this.translateVarDefs(methodDef.params);
        methodDef.thrown = this.translate(methodDef.thrown, null);
        methodDef.body = (Tree.Block)this.translate(methodDef.body, methodDef.sym.erasure().restype());
        methodDef.type = methodDef.type.erasure();
        this.result = methodDef;
        Scope.Entry entry = methodDef.sym.owner.members().lookup(methodDef.name);
        while (entry.sym != null) {
            if (entry.sym != methodDef.sym && entry.sym.type.erasure().isSameType(methodDef.type)) {
                this.log.error(methodDef.pos, "name.clash.same.erasure", methodDef.sym.toJava(), entry.sym.toJava());
                return;
            }
            entry = entry.next();
        }
    }

    public void visitNewArray(Tree.NewArray newArray) {
        newArray.elemtype = this.translate(newArray.elemtype, null);
        newArray.dims = this.translate(newArray.dims, null);
        newArray.elems = this.translate(newArray.elems, newArray.type.elemtype().erasure());
        newArray.type = newArray.type.erasure();
        this.result = newArray;
    }

    public void visitNewClass(Tree.NewClass newClass) {
        if (newClass.encl != null) {
            newClass.encl = this.translate(newClass.encl, newClass.encl.type.erasure());
        }
        newClass.clazz = this.translate(newClass.clazz, null);
        newClass.args = this.translateArgs(newClass.args, newClass.constructor.erasure().argtypes());
        newClass.def = (Tree.ClassDef)this.translate(newClass.def, null);
        newClass.type = newClass.type.erasure();
        this.result = newClass;
    }

    public void visitParens(Tree.Parens parens) {
        parens.expr = this.translate(parens.expr, null);
        parens.type = parens.type.erasure();
        this.result = parens;
    }

    public void visitReturn(Tree.Return return_) {
        return_.expr = this.translate(return_.expr);
        this.result = return_;
    }

    public void visitSelect(Tree.Select select) {
        Type type = select.selected.type;
        select.selected = this.translate(select.selected, type.erasure());
        if (select.type.constValue != null) {
            this.result = select;
        } else if (select.sym.kind == 4) {
            this.result = this.retype(select, select.sym.erasure(), this.pt);
        } else {
            select.type = select.type.erasure();
            this.result = select;
        }
    }

    public void visitSwitch(Tree.Switch switch_) {
        switch_.selector = this.translate(switch_.selector, null);
        switch_.cases = this.translateCases(switch_.cases);
        this.result = switch_;
    }

    public void visitSynchronized(Tree.Synchronized synchronized_) {
        synchronized_.lock = this.translate(synchronized_.lock, null);
        synchronized_.body = this.translate(synchronized_.body);
        this.result = synchronized_;
    }

    public void visitThrow(Tree.Throw throw_) {
        throw_.expr = this.translate(throw_.expr, throw_.expr.type.erasure());
        this.result = throw_;
    }

    public void visitTypeArray(Tree.TypeArray typeArray) {
        typeArray.elemtype = this.translate(typeArray.elemtype, null);
        typeArray.type = typeArray.type.erasure();
        this.result = typeArray;
    }

    public void visitTypeCast(Tree.TypeCast typeCast) {
        typeCast.clazz = this.translate(typeCast.clazz, null);
        typeCast.expr = this.translate(typeCast.expr, null);
        typeCast.type = typeCast.type.erasure();
        this.result = typeCast;
    }

    public void visitTypeTest(Tree.TypeTest typeTest) {
        typeTest.expr = this.translate(typeTest.expr, null);
        typeTest.clazz = this.translate(typeTest.clazz, null);
        this.result = typeTest;
    }

    public void visitUnary(Tree.Unary unary) {
        unary.arg = this.translate(unary.arg, (Type)unary.operator.type.argtypes().head);
        this.result = unary;
    }

    public void visitVarDef(Tree.VarDef varDef) {
        varDef.vartype = this.translate(varDef.vartype, null);
        varDef.init = this.translate(varDef.init, varDef.sym.erasure());
        varDef.type = varDef.type.erasure();
        this.result = varDef;
    }

    public void visitWhileLoop(Tree.WhileLoop whileLoop) {
        whileLoop.cond = this.translate(whileLoop.cond, null);
        whileLoop.body = this.translate(whileLoop.body);
        this.result = whileLoop;
    }

    private TransTypes(Context context) {
        context.put(transTypesKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
    }

    public static TransTypes instance(Context context) {
        TransTypes transTypes = (TransTypes)context.get(transTypesKey);
        if (transTypes == null) {
            transTypes = new TransTypes(context);
        }
        return transTypes;
    }

    Tree cast(Tree tree, Type type) {
        int n = this.make.pos;
        this.make.at(tree.pos);
        if (!tree.type.isSameType(type)) {
            tree = this.make.TypeCast(this.make.Type(type), tree).setType(type);
        }
        this.make.pos = n;
        return tree;
    }

    Tree coerce(Tree tree, Type type) {
        Type type2 = type.baseType();
        return tree.type.isAssignable(type2) ? tree : this.cast(tree, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree translate(Tree tree, Type type) {
        Type type2 = this.pt;
        try {
            this.pt = type;
            if (tree == null) {
                this.result = null;
            } else {
                tree.accept(this);
            }
        }
        finally {
            this.pt = type2;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree translateTopLevelClass(Tree tree, TreeMaker treeMaker) {
        try {
            this.make = treeMaker;
            this.overridden = Hashtable.make();
            this.pt = null;
            Tree tree2 = this.translate(tree, null);
            Object var5_4 = null;
            this.make = null;
            this.overridden = null;
            this.pt = null;
            return tree2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.make = null;
            this.overridden = null;
            this.pt = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List translate(List list, Type type) {
        List list2;
        Type type2 = this.pt;
        try {
            this.pt = type;
            list2 = this.translate(list);
        }
        finally {
            this.pt = type2;
        }
        return list2;
    }

    List translateArgs(List list, List list2) {
        List list3 = list;
        while (list3.nonEmpty()) {
            list3.head = this.translate((Tree)list3.head, (Type)list2.head);
            list2 = list2.tail;
            list3 = list3.tail;
        }
        return list;
    }

    Tree retype(Tree tree, Type type, Type type2) {
        if (type.tag > 8) {
            tree.type = type;
            if (type2 != null) {
                return this.coerce(tree, type2);
            }
        }
        return tree;
    }
}

